@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin.inputs

import com.pulumi.aws.dax.inputs.ClusterServerSideEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enabled Whether to enable encryption at rest. Defaults to `false`.
 */
public data class ClusterServerSideEncryptionArgs(
    public val enabled: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.dax.inputs.ClusterServerSideEncryptionArgs> {
    override fun toJava(): com.pulumi.aws.dax.inputs.ClusterServerSideEncryptionArgs =
        com.pulumi.aws.dax.inputs.ClusterServerSideEncryptionArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterServerSideEncryptionArgs].
 */
@PulumiTagMarker
public class ClusterServerSideEncryptionArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    /**
     * @param value Whether to enable encryption at rest. Defaults to `false`.
     */
    @JvmName("bymuqtocqtdjetkf")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Whether to enable encryption at rest. Defaults to `false`.
     */
    @JvmName("vqkrsavxmknvlwty")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    internal fun build(): ClusterServerSideEncryptionArgs = ClusterServerSideEncryptionArgs(
        enabled = enabled,
    )
}
