@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin.inputs

import com.pulumi.aws.dax.inputs.ParameterGroupParameterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The name of the parameter.
 * @property value The value for the parameter.
 */
public data class ParameterGroupParameterArgs(
    public val name: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.dax.inputs.ParameterGroupParameterArgs> {
    override fun toJava(): com.pulumi.aws.dax.inputs.ParameterGroupParameterArgs =
        com.pulumi.aws.dax.inputs.ParameterGroupParameterArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ParameterGroupParameterArgs].
 */
@PulumiTagMarker
public class ParameterGroupParameterArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The name of the parameter.
     */
    @JvmName("vkwbfwrgeqrdbljn")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The value for the parameter.
     */
    @JvmName("pdsrhkwicgmgwwdr")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The name of the parameter.
     */
    @JvmName("xiloqeshdqshfnxx")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The value for the parameter.
     */
    @JvmName("bvaihsgshktpvvjx")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ParameterGroupParameterArgs = ParameterGroupParameterArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
