@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.dax.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address
 * @property availabilityZone
 * @property id
 * @property port The port used by the configuration endpoint
 */
public data class ClusterNode(
    public val address: String? = null,
    public val availabilityZone: String? = null,
    public val id: String? = null,
    public val port: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.dax.outputs.ClusterNode): ClusterNode =
            ClusterNode(
                address = javaType.address().map({ args0 -> args0 }).orElse(null),
                availabilityZone = javaType.availabilityZone().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
            )
    }
}
