@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.aws.detective.InvitationAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Detective Invitation Accepter](https://docs.aws.amazon.com/detective/latest/APIReference/API_AcceptInvitation.html). Ensure that the accepter is configured to use the AWS account you wish to _accept_ the invitation from the primary graph owner account.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const primary = new aws.detective.Graph("primary", {});
 * const primaryMember = new aws.detective.Member("primary", {
 *     accountId: "ACCOUNT ID",
 *     emailAddress: "EMAIL",
 *     graphArn: primary.id,
 *     message: "Message of the invite",
 * });
 * const member = new aws.detective.InvitationAccepter("member", {graphArn: primary.graphArn}, {
 *     dependsOn: [primaryMember],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * primary = aws.detective.Graph("primary")
 * primary_member = aws.detective.Member("primary",
 *     account_id="ACCOUNT ID",
 *     email_address="EMAIL",
 *     graph_arn=primary.id,
 *     message="Message of the invite")
 * member = aws.detective.InvitationAccepter("member", graph_arn=primary.graph_arn,
 * opts = pulumi.ResourceOptions(depends_on=[primary_member]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var primary = new Aws.Detective.Graph("primary");
 *     var primaryMember = new Aws.Detective.Member("primary", new()
 *     {
 *         AccountId = "ACCOUNT ID",
 *         EmailAddress = "EMAIL",
 *         GraphArn = primary.Id,
 *         Message = "Message of the invite",
 *     });
 *     var member = new Aws.Detective.InvitationAccepter("member", new()
 *     {
 *         GraphArn = primary.GraphArn,
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             primaryMember,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/detective"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		primary, err := detective.NewGraph(ctx, "primary", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		primaryMember, err := detective.NewMember(ctx, "primary", &detective.MemberArgs{
 * 			AccountId:    pulumi.String("ACCOUNT ID"),
 * 			EmailAddress: pulumi.String("EMAIL"),
 * 			GraphArn:     primary.ID(),
 * 			Message:      pulumi.String("Message of the invite"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = detective.NewInvitationAccepter(ctx, "member", &detective.InvitationAccepterArgs{
 * 			GraphArn: primary.GraphArn,
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			primaryMember,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.Member;
 * import com.pulumi.aws.detective.MemberArgs;
 * import com.pulumi.aws.detective.InvitationAccepter;
 * import com.pulumi.aws.detective.InvitationAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primary = new Graph("primary");
 *         var primaryMember = new Member("primaryMember", MemberArgs.builder()
 *             .accountId("ACCOUNT ID")
 *             .emailAddress("EMAIL")
 *             .graphArn(primary.id())
 *             .message("Message of the invite")
 *             .build());
 *         var member = new InvitationAccepter("member", InvitationAccepterArgs.builder()
 *             .graphArn(primary.graphArn())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primaryMember)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   primary:
 *     type: aws:detective:Graph
 *   primaryMember:
 *     type: aws:detective:Member
 *     name: primary
 *     properties:
 *       accountId: ACCOUNT ID
 *       emailAddress: EMAIL
 *       graphArn: ${primary.id}
 *       message: Message of the invite
 *   member:
 *     type: aws:detective:InvitationAccepter
 *     properties:
 *       graphArn: ${primary.graphArn}
 *     options:
 *       dependson:
 *         - ${primaryMember}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_detective_invitation_accepter` using the graph ARN. For example:
 * ```sh
 * $ pulumi import aws:detective/invitationAccepter:InvitationAccepter example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d
 * ```
 * @property graphArn ARN of the behavior graph that the member account is accepting the invitation for.
 */
public data class InvitationAccepterArgs(
    public val graphArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.detective.InvitationAccepterArgs> {
    override fun toJava(): com.pulumi.aws.detective.InvitationAccepterArgs =
        com.pulumi.aws.detective.InvitationAccepterArgs.builder()
            .graphArn(graphArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InvitationAccepterArgs].
 */
@PulumiTagMarker
public class InvitationAccepterArgsBuilder internal constructor() {
    private var graphArn: Output<String>? = null

    /**
     * @param value ARN of the behavior graph that the member account is accepting the invitation for.
     */
    @JvmName("pfepcbtstrpbhihg")
    public suspend fun graphArn(`value`: Output<String>) {
        this.graphArn = value
    }

    /**
     * @param value ARN of the behavior graph that the member account is accepting the invitation for.
     */
    @JvmName("lccgywvxpgvqjhcw")
    public suspend fun graphArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphArn = mapped
    }

    internal fun build(): InvitationAccepterArgs = InvitationAccepterArgs(
        graphArn = graphArn,
    )
}
