@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.aws.detective.MemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Detective Member](https://docs.aws.amazon.com/detective/latest/APIReference/API_CreateMembers.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.detective.Graph("example", {});
 * const exampleMember = new aws.detective.Member("example", {
 *     accountId: "AWS ACCOUNT ID",
 *     emailAddress: "EMAIL",
 *     graphArn: example.id,
 *     message: "Message of the invitation",
 *     disableEmailNotification: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.detective.Graph("example")
 * example_member = aws.detective.Member("example",
 *     account_id="AWS ACCOUNT ID",
 *     email_address="EMAIL",
 *     graph_arn=example.id,
 *     message="Message of the invitation",
 *     disable_email_notification=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Detective.Graph("example");
 *     var exampleMember = new Aws.Detective.Member("example", new()
 *     {
 *         AccountId = "AWS ACCOUNT ID",
 *         EmailAddress = "EMAIL",
 *         GraphArn = example.Id,
 *         Message = "Message of the invitation",
 *         DisableEmailNotification = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/detective"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := detective.NewGraph(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = detective.NewMember(ctx, "example", &detective.MemberArgs{
 * 			AccountId:                pulumi.String("AWS ACCOUNT ID"),
 * 			EmailAddress:             pulumi.String("EMAIL"),
 * 			GraphArn:                 example.ID(),
 * 			Message:                  pulumi.String("Message of the invitation"),
 * 			DisableEmailNotification: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.detective.Graph;
 * import com.pulumi.aws.detective.Member;
 * import com.pulumi.aws.detective.MemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Graph("example");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("AWS ACCOUNT ID")
 *             .emailAddress("EMAIL")
 *             .graphArn(example.id())
 *             .message("Message of the invitation")
 *             .disableEmailNotification(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:detective:Graph
 *   exampleMember:
 *     type: aws:detective:Member
 *     name: example
 *     properties:
 *       accountId: AWS ACCOUNT ID
 *       emailAddress: EMAIL
 *       graphArn: ${example.id}
 *       message: Message of the invitation
 *       disableEmailNotification: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_detective_member` using the ARN of the graph followed by the account ID of the member account. For example:
 * ```sh
 * $ pulumi import aws:detective/member:Member example arn:aws:detective:us-east-1:123456789101:graph:231684d34gh74g4bae1dbc7bd807d02d/123456789012
 * ```
 * @property accountId AWS account ID for the account.
 * @property disableEmailNotification If set to true, then the root user of the invited account will _not_ receive an email notification. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. By default, this is set to `false`.
 * @property emailAddress Email address for the account.
 * @property graphArn ARN of the behavior graph to invite the member accounts to contribute their data to.
 * @property message A custom message to include in the invitation. Amazon Detective adds this message to the standard content that it sends for an invitation.
 */
public data class MemberArgs(
    public val accountId: Output<String>? = null,
    public val disableEmailNotification: Output<Boolean>? = null,
    public val emailAddress: Output<String>? = null,
    public val graphArn: Output<String>? = null,
    public val message: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.detective.MemberArgs> {
    override fun toJava(): com.pulumi.aws.detective.MemberArgs =
        com.pulumi.aws.detective.MemberArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .disableEmailNotification(disableEmailNotification?.applyValue({ args0 -> args0 }))
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .graphArn(graphArn?.applyValue({ args0 -> args0 }))
            .message(message?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MemberArgs].
 */
@PulumiTagMarker
public class MemberArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var disableEmailNotification: Output<Boolean>? = null

    private var emailAddress: Output<String>? = null

    private var graphArn: Output<String>? = null

    private var message: Output<String>? = null

    /**
     * @param value AWS account ID for the account.
     */
    @JvmName("extifqinspqosvhe")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value If set to true, then the root user of the invited account will _not_ receive an email notification. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. By default, this is set to `false`.
     */
    @JvmName("subgrwmlojqhlgry")
    public suspend fun disableEmailNotification(`value`: Output<Boolean>) {
        this.disableEmailNotification = value
    }

    /**
     * @param value Email address for the account.
     */
    @JvmName("hlgkpssqkngphwqb")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value ARN of the behavior graph to invite the member accounts to contribute their data to.
     */
    @JvmName("oumycolgpbvtwkii")
    public suspend fun graphArn(`value`: Output<String>) {
        this.graphArn = value
    }

    /**
     * @param value A custom message to include in the invitation. Amazon Detective adds this message to the standard content that it sends for an invitation.
     */
    @JvmName("gsqagedlpdhsafqg")
    public suspend fun message(`value`: Output<String>) {
        this.message = value
    }

    /**
     * @param value AWS account ID for the account.
     */
    @JvmName("tgohawraqiqxnyxy")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value If set to true, then the root user of the invited account will _not_ receive an email notification. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. By default, this is set to `false`.
     */
    @JvmName("dqiosidecsprjmdi")
    public suspend fun disableEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableEmailNotification = mapped
    }

    /**
     * @param value Email address for the account.
     */
    @JvmName("rlruqcdpchybyrbq")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value ARN of the behavior graph to invite the member accounts to contribute their data to.
     */
    @JvmName("bsxqpiyokeoxyxos")
    public suspend fun graphArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.graphArn = mapped
    }

    /**
     * @param value A custom message to include in the invitation. Amazon Detective adds this message to the standard content that it sends for an invitation.
     */
    @JvmName("gncdkbebjerobnxb")
    public suspend fun message(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.message = mapped
    }

    internal fun build(): MemberArgs = MemberArgs(
        accountId = accountId,
        disableEmailNotification = disableEmailNotification,
        emailAddress = emailAddress,
        graphArn = graphArn,
        message = message,
    )
}
