@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationAdminAccount].
 */
@PulumiTagMarker
public class OrganizationAdminAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationAdminAccountArgs = OrganizationAdminAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationAdminAccountArgsBuilder.() -> Unit) {
        val builder = OrganizationAdminAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationAdminAccount {
        val builtJavaResource =
            com.pulumi.aws.detective.OrganizationAdminAccount(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationAdminAccount(builtJavaResource)
    }
}

/**
 * Manages a Detective Organization Admin Account. The AWS account utilizing this resource must be an Organizations primary account. More information about Organizations support in Detective can be found in the [Detective User Guide](https://docs.aws.amazon.com/detective/latest/adminguide/accounts-orgs-transition.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.organizations.Organization("example", {
 *     awsServiceAccessPrincipals: ["detective&#46;amazonaws&#46;com"],
 *     featureSet: "ALL",
 * });
 * const exampleOrganizationAdminAccount = new aws.detective.OrganizationAdminAccount("example", {accountId: "123456789012"}, {
 *     dependsOn: [example],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.organizations.Organization("example",
 *     aws_service_access_principals=["detective&#46;amazonaws&#46;com"],
 *     feature_set="ALL")
 * example_organization_admin_account = aws.detective.OrganizationAdminAccount("example", account_id="123456789012",
 * opts = pulumi.ResourceOptions(depends_on=[example]))
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Organizations.Organization("example", new()
 *     {
 *         AwsServiceAccessPrincipals = new[]
 *         {
 *             "detective.amazonaws.com",
 *         },
 *         FeatureSet = "ALL",
 *     });
 *     var exampleOrganizationAdminAccount = new Aws.Detective.OrganizationAdminAccount("example", new()
 *     {
 *         AccountId = "123456789012",
 *     }, new CustomResourceOptions
 *     {
 *         DependsOn =
 *         {
 *             example,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/detective"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/organizations"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := organizations.NewOrganization(ctx, "example", &organizations.OrganizationArgs{
 * 			AwsServiceAccessPrincipals: pulumi.StringArray{
 * 				pulumi.String("detective.amazonaws.com"),
 * 			},
 * 			FeatureSet: pulumi.String("ALL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = detective.NewOrganizationAdminAccount(ctx, "example", &detective.OrganizationAdminAccountArgs{
 * 			AccountId: pulumi.String("123456789012"),
 * 		}, pulumi.DependsOn([]pulumi.Resource{
 * 			example,
 * 		}))
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.organizations.Organization;
 * import com.pulumi.aws.organizations.OrganizationArgs;
 * import com.pulumi.aws.detective.OrganizationAdminAccount;
 * import com.pulumi.aws.detective.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Organization("example", OrganizationArgs.builder()
 *             .awsServiceAccessPrincipals("detective.amazonaws.com")
 *             .featureSet("ALL")
 *             .build());
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .accountId("123456789012")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(example)
 *                 .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:organizations:Organization
 *     properties:
 *       awsServiceAccessPrincipals:
 *         - detective.amazonaws.com
 *       featureSet: ALL
 *   exampleOrganizationAdminAccount:
 *     type: aws:detective:OrganizationAdminAccount
 *     name: example
 *     properties:
 *       accountId: '123456789012'
 *     options:
 *       dependson:
 *         - ${example}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_detective_organization_admin_account` using `account_id`. For example:
 * ```sh
 * $ pulumi import aws:detective/organizationAdminAccount:OrganizationAdminAccount example 123456789012
 * ```
 */
public class OrganizationAdminAccount internal constructor(
    override val javaResource: com.pulumi.aws.detective.OrganizationAdminAccount,
) : KotlinCustomResource(javaResource, OrganizationAdminAccountMapper) {
    /**
     * AWS account identifier to designate as a delegated administrator for Detective.
     */
    public val accountId: Output<String>
        get() = javaResource.accountId().applyValue({ args0 -> args0 })
}

public object OrganizationAdminAccountMapper : ResourceMapper<OrganizationAdminAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.detective.OrganizationAdminAccount::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationAdminAccount =
        OrganizationAdminAccount(javaResource as com.pulumi.aws.detective.OrganizationAdminAccount)
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationAdminAccount].
 */
public suspend fun organizationAdminAccount(
    name: String,
    block: suspend OrganizationAdminAccountResourceBuilder.() -> Unit,
): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationAdminAccount(name: String): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
