@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.detective.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationConfiguration].
 */
@PulumiTagMarker
public class OrganizationConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationConfigurationArgs = OrganizationConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationConfigurationArgsBuilder.() -> Unit) {
        val builder = OrganizationConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OrganizationConfiguration {
        val builtJavaResource =
            com.pulumi.aws.detective.OrganizationConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return OrganizationConfiguration(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:detective:Graph
 *     properties:
 *       enable: true
 *   exampleOrganizationConfiguration:
 *     type: aws:detective:OrganizationConfiguration
 *     name: example
 *     properties:
 *       autoEnable: true
 *       graphArn: ${example.graphArn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_detective_organization_admin_account` using the behavior graph ARN. For example:
 * ```sh
 * $ pulumi import aws:detective/organizationConfiguration:OrganizationConfiguration example arn:aws:detective:us-east-1:123456789012:graph:00b00fd5aecc0ab60a708659477e9617
 * ```
 */
public class OrganizationConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.detective.OrganizationConfiguration,
) : KotlinCustomResource(javaResource, OrganizationConfigurationMapper) {
    /**
     * When this setting is enabled, all new accounts that are created in, or added to, the organization are added as a member accounts of the organization’s Detective delegated administrator and Detective is enabled in that AWS Region.
     */
    public val autoEnable: Output<Boolean>
        get() = javaResource.autoEnable().applyValue({ args0 -> args0 })

    /**
     * ARN of the behavior graph.
     */
    public val graphArn: Output<String>
        get() = javaResource.graphArn().applyValue({ args0 -> args0 })
}

public object OrganizationConfigurationMapper : ResourceMapper<OrganizationConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.detective.OrganizationConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationConfiguration =
        OrganizationConfiguration(javaResource as com.pulumi.aws.detective.OrganizationConfiguration)
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationConfiguration].
 */
public suspend fun organizationConfiguration(
    name: String,
    block: suspend OrganizationConfigurationResourceBuilder.() -> Unit,
): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationConfiguration(name: String): OrganizationConfiguration {
    val builder = OrganizationConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
