@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.kotlin.outputs.DevicePoolRule
import com.pulumi.aws.devicefarm.kotlin.outputs.DevicePoolRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [DevicePool].
 */
@PulumiTagMarker
public class DevicePoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DevicePoolArgs = DevicePoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DevicePoolArgsBuilder.() -> Unit) {
        val builder = DevicePoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DevicePool {
        val builtJavaResource = com.pulumi.aws.devicefarm.DevicePool(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DevicePool(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Device Farm Device Pools.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devicefarm.DevicePool("example", {
 *     name: "example",
 *     projectArn: exampleAwsDevicefarmProject.arn,
 *     rules: [{
 *         attribute: "OS_VERSION",
 *         operator: "EQUALS",
 *         value: "\"AVAILABLE\"",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devicefarm.DevicePool("example",
 *     name="example",
 *     project_arn=example_aws_devicefarm_project["arn"],
 *     rules=[{
 *         "attribute": "OS_VERSION",
 *         "operator": "EQUALS",
 *         "value": "\"AVAILABLE\"",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DeviceFarm.DevicePool("example", new()
 *     {
 *         Name = "example",
 *         ProjectArn = exampleAwsDevicefarmProject.Arn,
 *         Rules = new[]
 *         {
 *             new Aws.DeviceFarm.Inputs.DevicePoolRuleArgs
 *             {
 *                 Attribute = "OS_VERSION",
 *                 Operator = "EQUALS",
 *                 Value = "\"AVAILABLE\"",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devicefarm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devicefarm.NewDevicePool(ctx, "example", &devicefarm.DevicePoolArgs{
 * 			Name:       pulumi.String("example"),
 * 			ProjectArn: pulumi.Any(exampleAwsDevicefarmProject.Arn),
 * 			Rules: devicefarm.DevicePoolRuleArray{
 * 				&devicefarm.DevicePoolRuleArgs{
 * 					Attribute: pulumi.String("OS_VERSION"),
 * 					Operator:  pulumi.String("EQUALS"),
 * 					Value:     pulumi.String("\"AVAILABLE\""),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.DevicePool;
 * import com.pulumi.aws.devicefarm.DevicePoolArgs;
 * import com.pulumi.aws.devicefarm.inputs.DevicePoolRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DevicePool("example", DevicePoolArgs.builder()
 *             .name("example")
 *             .projectArn(exampleAwsDevicefarmProject.arn())
 *             .rules(DevicePoolRuleArgs.builder()
 *                 .attribute("OS_VERSION")
 *                 .operator("EQUALS")
 *                 .value("\"AVAILABLE\"")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devicefarm:DevicePool
 *     properties:
 *       name: example
 *       projectArn: ${exampleAwsDevicefarmProject.arn}
 *       rules:
 *         - attribute: OS_VERSION
 *           operator: EQUALS
 *           value: '"AVAILABLE"'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DeviceFarm Device Pools using their ARN. For example:
 * ```sh
 * $ pulumi import aws:devicefarm/devicePool:DevicePool example arn:aws:devicefarm:us-west-2:123456789012:devicepool:4fa784c7-ccb4-4dbf-ba4f-02198320daa1/4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 */
public class DevicePool internal constructor(
    override val javaResource: com.pulumi.aws.devicefarm.DevicePool,
) : KotlinCustomResource(javaResource, DevicePoolMapper) {
    /**
     * The Amazon Resource Name of this Device Pool
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The device pool's description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of devices that Device Farm can add to your device pool.
     */
    public val maxDevices: Output<Int>?
        get() = javaResource.maxDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Device Pool
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the project for the device pool.
     */
    public val projectArn: Output<String>
        get() = javaResource.projectArn().applyValue({ args0 -> args0 })

    /**
     * The device pool's rules. See Rule.
     */
    public val rules: Output<List<DevicePoolRule>>
        get() = javaResource.rules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DevicePoolMapper : ResourceMapper<DevicePool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devicefarm.DevicePool::class == javaResource::class

    override fun map(javaResource: Resource): DevicePool = DevicePool(
        javaResource as
            com.pulumi.aws.devicefarm.DevicePool,
    )
}

/**
 * @see [DevicePool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DevicePool].
 */
public suspend fun devicePool(name: String, block: suspend DevicePoolResourceBuilder.() -> Unit): DevicePool {
    val builder = DevicePoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DevicePool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun devicePool(name: String): DevicePool {
    val builder = DevicePoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
