@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.DevicePoolArgs.builder
import com.pulumi.aws.devicefarm.kotlin.inputs.DevicePoolRuleArgs
import com.pulumi.aws.devicefarm.kotlin.inputs.DevicePoolRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Device Farm Device Pools.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devicefarm.DevicePool("example", {
 *     name: "example",
 *     projectArn: exampleAwsDevicefarmProject.arn,
 *     rules: [{
 *         attribute: "OS_VERSION",
 *         operator: "EQUALS",
 *         value: "\"AVAILABLE\"",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devicefarm.DevicePool("example",
 *     name="example",
 *     project_arn=example_aws_devicefarm_project["arn"],
 *     rules=[{
 *         "attribute": "OS_VERSION",
 *         "operator": "EQUALS",
 *         "value": "\"AVAILABLE\"",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DeviceFarm.DevicePool("example", new()
 *     {
 *         Name = "example",
 *         ProjectArn = exampleAwsDevicefarmProject.Arn,
 *         Rules = new[]
 *         {
 *             new Aws.DeviceFarm.Inputs.DevicePoolRuleArgs
 *             {
 *                 Attribute = "OS_VERSION",
 *                 Operator = "EQUALS",
 *                 Value = "\"AVAILABLE\"",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devicefarm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devicefarm.NewDevicePool(ctx, "example", &devicefarm.DevicePoolArgs{
 * 			Name:       pulumi.String("example"),
 * 			ProjectArn: pulumi.Any(exampleAwsDevicefarmProject.Arn),
 * 			Rules: devicefarm.DevicePoolRuleArray{
 * 				&devicefarm.DevicePoolRuleArgs{
 * 					Attribute: pulumi.String("OS_VERSION"),
 * 					Operator:  pulumi.String("EQUALS"),
 * 					Value:     pulumi.String("\"AVAILABLE\""),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.DevicePool;
 * import com.pulumi.aws.devicefarm.DevicePoolArgs;
 * import com.pulumi.aws.devicefarm.inputs.DevicePoolRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DevicePool("example", DevicePoolArgs.builder()
 *             .name("example")
 *             .projectArn(exampleAwsDevicefarmProject.arn())
 *             .rules(DevicePoolRuleArgs.builder()
 *                 .attribute("OS_VERSION")
 *                 .operator("EQUALS")
 *                 .value("\"AVAILABLE\"")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devicefarm:DevicePool
 *     properties:
 *       name: example
 *       projectArn: ${exampleAwsDevicefarmProject.arn}
 *       rules:
 *         - attribute: OS_VERSION
 *           operator: EQUALS
 *           value: '"AVAILABLE"'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DeviceFarm Device Pools using their ARN. For example:
 * ```sh
 * $ pulumi import aws:devicefarm/devicePool:DevicePool example arn:aws:devicefarm:us-west-2:123456789012:devicepool:4fa784c7-ccb4-4dbf-ba4f-02198320daa1/4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * @property description The device pool's description.
 * @property maxDevices The number of devices that Device Farm can add to your device pool.
 * @property name The name of the Device Pool
 * @property projectArn The ARN of the project for the device pool.
 * @property rules The device pool's rules. See Rule.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class DevicePoolArgs(
    public val description: Output<String>? = null,
    public val maxDevices: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val projectArn: Output<String>? = null,
    public val rules: Output<List<DevicePoolRuleArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.devicefarm.DevicePoolArgs> {
    override fun toJava(): com.pulumi.aws.devicefarm.DevicePoolArgs =
        com.pulumi.aws.devicefarm.DevicePoolArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .maxDevices(maxDevices?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectArn(projectArn?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DevicePoolArgs].
 */
@PulumiTagMarker
public class DevicePoolArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var maxDevices: Output<Int>? = null

    private var name: Output<String>? = null

    private var projectArn: Output<String>? = null

    private var rules: Output<List<DevicePoolRuleArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The device pool's description.
     */
    @JvmName("lrcidmmfparyigjn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The number of devices that Device Farm can add to your device pool.
     */
    @JvmName("fwyjkmpuicabdxxx")
    public suspend fun maxDevices(`value`: Output<Int>) {
        this.maxDevices = value
    }

    /**
     * @param value The name of the Device Pool
     */
    @JvmName("ddsmvkuvourocjpm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the project for the device pool.
     */
    @JvmName("ydwliymjqjxfwhyh")
    public suspend fun projectArn(`value`: Output<String>) {
        this.projectArn = value
    }

    /**
     * @param value The device pool's rules. See Rule.
     */
    @JvmName("ajnbhicakgeclbeu")
    public suspend fun rules(`value`: Output<List<DevicePoolRuleArgs>>) {
        this.rules = value
    }

    @JvmName("llbdjlttmgvdvhmk")
    public suspend fun rules(vararg values: Output<DevicePoolRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The device pool's rules. See Rule.
     */
    @JvmName("hplyymqnpdsgpppf")
    public suspend fun rules(values: List<Output<DevicePoolRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jlopbibftihqbhwr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The device pool's description.
     */
    @JvmName("wgwurkbmxpnoghxa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The number of devices that Device Farm can add to your device pool.
     */
    @JvmName("amiqmxapsjuisxar")
    public suspend fun maxDevices(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDevices = mapped
    }

    /**
     * @param value The name of the Device Pool
     */
    @JvmName("ucyalvpijcwivvua")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the project for the device pool.
     */
    @JvmName("rwqimdqcjxodtpsr")
    public suspend fun projectArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectArn = mapped
    }

    /**
     * @param value The device pool's rules. See Rule.
     */
    @JvmName("niypmgbdpfgtnhat")
    public suspend fun rules(`value`: List<DevicePoolRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The device pool's rules. See Rule.
     */
    @JvmName("fjoabspjfveacqvu")
    public suspend fun rules(argument: List<suspend DevicePoolRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DevicePoolRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The device pool's rules. See Rule.
     */
    @JvmName("kjhdnxursjmjakgw")
    public suspend fun rules(vararg argument: suspend DevicePoolRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DevicePoolRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The device pool's rules. See Rule.
     */
    @JvmName("ayharvnrwttoeuqu")
    public suspend fun rules(argument: suspend DevicePoolRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DevicePoolRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The device pool's rules. See Rule.
     */
    @JvmName("ppeotghxiijoeldd")
    public suspend fun rules(vararg values: DevicePoolRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tfwhwjqevhymdxbw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("smpkvumoafrlynbq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DevicePoolArgs = DevicePoolArgs(
        description = description,
        maxDevices = maxDevices,
        name = name,
        projectArn = projectArn,
        rules = rules,
        tags = tags,
    )
}
