@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [NetworkProfile].
 */
@PulumiTagMarker
public class NetworkProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NetworkProfileArgs = NetworkProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NetworkProfileArgsBuilder.() -> Unit) {
        val builder = NetworkProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NetworkProfile {
        val builtJavaResource = com.pulumi.aws.devicefarm.NetworkProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NetworkProfile(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Device Farm Network Profiles.
 * ∂
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devicefarm.Project("example", {name: "example"});
 * const exampleNetworkProfile = new aws.devicefarm.NetworkProfile("example", {
 *     name: "example",
 *     projectArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devicefarm.Project("example", name="example")
 * example_network_profile = aws.devicefarm.NetworkProfile("example",
 *     name="example",
 *     project_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DeviceFarm.Project("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleNetworkProfile = new Aws.DeviceFarm.NetworkProfile("example", new()
 *     {
 *         Name = "example",
 *         ProjectArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devicefarm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := devicefarm.NewProject(ctx, "example", &devicefarm.ProjectArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = devicefarm.NewNetworkProfile(ctx, "example", &devicefarm.NetworkProfileArgs{
 * 			Name:       pulumi.String("example"),
 * 			ProjectArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.Project;
 * import com.pulumi.aws.devicefarm.ProjectArgs;
 * import com.pulumi.aws.devicefarm.NetworkProfile;
 * import com.pulumi.aws.devicefarm.NetworkProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleNetworkProfile = new NetworkProfile("exampleNetworkProfile", NetworkProfileArgs.builder()
 *             .name("example")
 *             .projectArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devicefarm:Project
 *     properties:
 *       name: example
 *   exampleNetworkProfile:
 *     type: aws:devicefarm:NetworkProfile
 *     name: example
 *     properties:
 *       name: example
 *       projectArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DeviceFarm Network Profiles using their ARN. For example:
 * ```sh
 * $ pulumi import aws:devicefarm/networkProfile:NetworkProfile example arn:aws:devicefarm:us-west-2:123456789012:networkprofile:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 */
public class NetworkProfile internal constructor(
    override val javaResource: com.pulumi.aws.devicefarm.NetworkProfile,
) : KotlinCustomResource(javaResource, NetworkProfileMapper) {
    /**
     * The Amazon Resource Name of this network profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The description of the network profile.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
     */
    public val downlinkBandwidthBits: Output<Int>?
        get() = javaResource.downlinkBandwidthBits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
     */
    public val downlinkDelayMs: Output<Int>?
        get() = javaResource.downlinkDelayMs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
     */
    public val downlinkJitterMs: Output<Int>?
        get() = javaResource.downlinkJitterMs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Proportion of received packets that fail to arrive from `0` to `100` percent.
     */
    public val downlinkLossPercent: Output<Int>?
        get() = javaResource.downlinkLossPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name for the network profile.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the project for the network profile.
     */
    public val projectArn: Output<String>
        get() = javaResource.projectArn().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of network profile to create. Valid values are listed are `PRIVATE` and `CURATED`.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
     */
    public val uplinkBandwidthBits: Output<Int>?
        get() = javaResource.uplinkBandwidthBits().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
     */
    public val uplinkDelayMs: Output<Int>?
        get() = javaResource.uplinkDelayMs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
     */
    public val uplinkJitterMs: Output<Int>?
        get() = javaResource.uplinkJitterMs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Proportion of received packets that fail to arrive from `0` to `100` percent.
     */
    public val uplinkLossPercent: Output<Int>?
        get() = javaResource.uplinkLossPercent().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NetworkProfileMapper : ResourceMapper<NetworkProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devicefarm.NetworkProfile::class == javaResource::class

    override fun map(javaResource: Resource): NetworkProfile = NetworkProfile(
        javaResource as
            com.pulumi.aws.devicefarm.NetworkProfile,
    )
}

/**
 * @see [NetworkProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NetworkProfile].
 */
public suspend fun networkProfile(
    name: String,
    block: suspend NetworkProfileResourceBuilder.() -> Unit,
): NetworkProfile {
    val builder = NetworkProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NetworkProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun networkProfile(name: String): NetworkProfile {
    val builder = NetworkProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
