@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.NetworkProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage AWS Device Farm Network Profiles.
 * ∂
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devicefarm.Project("example", {name: "example"});
 * const exampleNetworkProfile = new aws.devicefarm.NetworkProfile("example", {
 *     name: "example",
 *     projectArn: example.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devicefarm.Project("example", name="example")
 * example_network_profile = aws.devicefarm.NetworkProfile("example",
 *     name="example",
 *     project_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DeviceFarm.Project("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleNetworkProfile = new Aws.DeviceFarm.NetworkProfile("example", new()
 *     {
 *         Name = "example",
 *         ProjectArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devicefarm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := devicefarm.NewProject(ctx, "example", &devicefarm.ProjectArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = devicefarm.NewNetworkProfile(ctx, "example", &devicefarm.NetworkProfileArgs{
 * 			Name:       pulumi.String("example"),
 * 			ProjectArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.Project;
 * import com.pulumi.aws.devicefarm.ProjectArgs;
 * import com.pulumi.aws.devicefarm.NetworkProfile;
 * import com.pulumi.aws.devicefarm.NetworkProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleNetworkProfile = new NetworkProfile("exampleNetworkProfile", NetworkProfileArgs.builder()
 *             .name("example")
 *             .projectArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devicefarm:Project
 *     properties:
 *       name: example
 *   exampleNetworkProfile:
 *     type: aws:devicefarm:NetworkProfile
 *     name: example
 *     properties:
 *       name: example
 *       projectArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DeviceFarm Network Profiles using their ARN. For example:
 * ```sh
 * $ pulumi import aws:devicefarm/networkProfile:NetworkProfile example arn:aws:devicefarm:us-west-2:123456789012:networkprofile:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 * @property description The description of the network profile.
 * @property downlinkBandwidthBits The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
 * @property downlinkDelayMs Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
 * @property downlinkJitterMs Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
 * @property downlinkLossPercent Proportion of received packets that fail to arrive from `0` to `100` percent.
 * @property name The name for the network profile.
 * @property projectArn The ARN of the project for the network profile.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of network profile to create. Valid values are listed are `PRIVATE` and `CURATED`.
 * @property uplinkBandwidthBits The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
 * @property uplinkDelayMs Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
 * @property uplinkJitterMs Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
 * @property uplinkLossPercent Proportion of received packets that fail to arrive from `0` to `100` percent.
 */
public data class NetworkProfileArgs(
    public val description: Output<String>? = null,
    public val downlinkBandwidthBits: Output<Int>? = null,
    public val downlinkDelayMs: Output<Int>? = null,
    public val downlinkJitterMs: Output<Int>? = null,
    public val downlinkLossPercent: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val projectArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val uplinkBandwidthBits: Output<Int>? = null,
    public val uplinkDelayMs: Output<Int>? = null,
    public val uplinkJitterMs: Output<Int>? = null,
    public val uplinkLossPercent: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.devicefarm.NetworkProfileArgs> {
    override fun toJava(): com.pulumi.aws.devicefarm.NetworkProfileArgs =
        com.pulumi.aws.devicefarm.NetworkProfileArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .downlinkBandwidthBits(downlinkBandwidthBits?.applyValue({ args0 -> args0 }))
            .downlinkDelayMs(downlinkDelayMs?.applyValue({ args0 -> args0 }))
            .downlinkJitterMs(downlinkJitterMs?.applyValue({ args0 -> args0 }))
            .downlinkLossPercent(downlinkLossPercent?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .projectArn(projectArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .uplinkBandwidthBits(uplinkBandwidthBits?.applyValue({ args0 -> args0 }))
            .uplinkDelayMs(uplinkDelayMs?.applyValue({ args0 -> args0 }))
            .uplinkJitterMs(uplinkJitterMs?.applyValue({ args0 -> args0 }))
            .uplinkLossPercent(uplinkLossPercent?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkProfileArgs].
 */
@PulumiTagMarker
public class NetworkProfileArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var downlinkBandwidthBits: Output<Int>? = null

    private var downlinkDelayMs: Output<Int>? = null

    private var downlinkJitterMs: Output<Int>? = null

    private var downlinkLossPercent: Output<Int>? = null

    private var name: Output<String>? = null

    private var projectArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var uplinkBandwidthBits: Output<Int>? = null

    private var uplinkDelayMs: Output<Int>? = null

    private var uplinkJitterMs: Output<Int>? = null

    private var uplinkLossPercent: Output<Int>? = null

    /**
     * @param value The description of the network profile.
     */
    @JvmName("smrtypdcjfftbcbq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
     */
    @JvmName("owtgkcxcioiktarx")
    public suspend fun downlinkBandwidthBits(`value`: Output<Int>) {
        this.downlinkBandwidthBits = value
    }

    /**
     * @param value Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("jefxcgdiwvmnnajo")
    public suspend fun downlinkDelayMs(`value`: Output<Int>) {
        this.downlinkDelayMs = value
    }

    /**
     * @param value Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("jakcoqjcauyphaln")
    public suspend fun downlinkJitterMs(`value`: Output<Int>) {
        this.downlinkJitterMs = value
    }

    /**
     * @param value Proportion of received packets that fail to arrive from `0` to `100` percent.
     */
    @JvmName("jjllgmpsjtbyuypx")
    public suspend fun downlinkLossPercent(`value`: Output<Int>) {
        this.downlinkLossPercent = value
    }

    /**
     * @param value The name for the network profile.
     */
    @JvmName("plcyqebymxltgysl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the project for the network profile.
     */
    @JvmName("kpsiqcxylpsbrjwc")
    public suspend fun projectArn(`value`: Output<String>) {
        this.projectArn = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wkccmusjxlkuasaf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of network profile to create. Valid values are listed are `PRIVATE` and `CURATED`.
     */
    @JvmName("xrxtltvkasrpmfeq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
     */
    @JvmName("rwqvvmjilcxjpemv")
    public suspend fun uplinkBandwidthBits(`value`: Output<Int>) {
        this.uplinkBandwidthBits = value
    }

    /**
     * @param value Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("osrjogfsewweaxsj")
    public suspend fun uplinkDelayMs(`value`: Output<Int>) {
        this.uplinkDelayMs = value
    }

    /**
     * @param value Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("yfvmntykdyyruvfh")
    public suspend fun uplinkJitterMs(`value`: Output<Int>) {
        this.uplinkJitterMs = value
    }

    /**
     * @param value Proportion of received packets that fail to arrive from `0` to `100` percent.
     */
    @JvmName("frepiyfchtghpkgv")
    public suspend fun uplinkLossPercent(`value`: Output<Int>) {
        this.uplinkLossPercent = value
    }

    /**
     * @param value The description of the network profile.
     */
    @JvmName("rmemlvciwrokwioq")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
     */
    @JvmName("nqheqyikexmtxfsf")
    public suspend fun downlinkBandwidthBits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downlinkBandwidthBits = mapped
    }

    /**
     * @param value Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("bmxjialprogyierb")
    public suspend fun downlinkDelayMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downlinkDelayMs = mapped
    }

    /**
     * @param value Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("uqphfpqsjctnocse")
    public suspend fun downlinkJitterMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downlinkJitterMs = mapped
    }

    /**
     * @param value Proportion of received packets that fail to arrive from `0` to `100` percent.
     */
    @JvmName("euabwatktrrwgkgb")
    public suspend fun downlinkLossPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.downlinkLossPercent = mapped
    }

    /**
     * @param value The name for the network profile.
     */
    @JvmName("jqxlsmdtyyhvqlvn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the project for the network profile.
     */
    @JvmName("vnhdlhdberyowgwx")
    public suspend fun projectArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectArn = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bdelhhfpqpgdvplt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mybukvmasuhwhsyn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of network profile to create. Valid values are listed are `PRIVATE` and `CURATED`.
     */
    @JvmName("lfbvqnnqwkvpjosr")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The data throughput rate in bits per second, as an integer from `0` to `104857600`. Default value is `104857600`.
     */
    @JvmName("tsuixpmwvnbspcat")
    public suspend fun uplinkBandwidthBits(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uplinkBandwidthBits = mapped
    }

    /**
     * @param value Delay time for all packets to destination in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("mcicgwdnfgatfupk")
    public suspend fun uplinkDelayMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uplinkDelayMs = mapped
    }

    /**
     * @param value Time variation in the delay of received packets in milliseconds as an integer from `0` to `2000`.
     */
    @JvmName("lfvryeywrynmmwtc")
    public suspend fun uplinkJitterMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uplinkJitterMs = mapped
    }

    /**
     * @param value Proportion of received packets that fail to arrive from `0` to `100` percent.
     */
    @JvmName("buptydxwxiejnehy")
    public suspend fun uplinkLossPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uplinkLossPercent = mapped
    }

    internal fun build(): NetworkProfileArgs = NetworkProfileArgs(
        description = description,
        downlinkBandwidthBits = downlinkBandwidthBits,
        downlinkDelayMs = downlinkDelayMs,
        downlinkJitterMs = downlinkJitterMs,
        downlinkLossPercent = downlinkLossPercent,
        name = name,
        projectArn = projectArn,
        tags = tags,
        type = type,
        uplinkBandwidthBits = uplinkBandwidthBits,
        uplinkDelayMs = uplinkDelayMs,
        uplinkJitterMs = uplinkJitterMs,
        uplinkLossPercent = uplinkLossPercent,
    )
}
