@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.aws.devicefarm.kotlin.outputs.TestGridProjectVpcConfig
import com.pulumi.aws.devicefarm.kotlin.outputs.TestGridProjectVpcConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [TestGridProject].
 */
@PulumiTagMarker
public class TestGridProjectResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: TestGridProjectArgs = TestGridProjectArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend TestGridProjectArgsBuilder.() -> Unit) {
        val builder = TestGridProjectArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): TestGridProject {
        val builtJavaResource = com.pulumi.aws.devicefarm.TestGridProject(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return TestGridProject(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Device Farm Test Grid Projects.
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devicefarm.TestGridProject("example", {
 *     name: "example",
 *     vpcConfig: {
 *         vpcId: exampleAwsVpc.id,
 *         subnetIds: exampleAwsSubnet.map(__item => __item.id),
 *         securityGroupIds: exampleAwsSecurityGroup.map(__item => __item.id),
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devicefarm.TestGridProject("example",
 *     name="example",
 *     vpc_config={
 *         "vpc_id": example_aws_vpc["id"],
 *         "subnet_ids": [__item["id"] for __item in example_aws_subnet],
 *         "security_group_ids": [__item["id"] for __item in example_aws_security_group],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DeviceFarm.TestGridProject("example", new()
 *     {
 *         Name = "example",
 *         VpcConfig = new Aws.DeviceFarm.Inputs.TestGridProjectVpcConfigArgs
 *         {
 *             VpcId = exampleAwsVpc.Id,
 *             SubnetIds = exampleAwsSubnet.Select(__item => __item.Id).ToList(),
 *             SecurityGroupIds = exampleAwsSecurityGroup.Select(__item => __item.Id).ToList(),
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devicefarm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := devicefarm.NewTestGridProject(ctx, "example", &devicefarm.TestGridProjectArgs{
 * Name: pulumi.String("example"),
 * VpcConfig: &devicefarm.TestGridProjectVpcConfigArgs{
 * VpcId: pulumi.Any(exampleAwsVpc.Id),
 * SubnetIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:4,24-46)),
 * SecurityGroupIds: []pulumi.String(%!v(PANIC=Format method: fatal: A failure has occurred: unlowered splat expression @ example.pp:5,24-53)),
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.TestGridProject;
 * import com.pulumi.aws.devicefarm.TestGridProjectArgs;
 * import com.pulumi.aws.devicefarm.inputs.TestGridProjectVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new TestGridProject("example", TestGridProjectArgs.builder()
 *             .name("example")
 *             .vpcConfig(TestGridProjectVpcConfigArgs.builder()
 *                 .vpcId(exampleAwsVpc.id())
 *                 .subnetIds(exampleAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *                 .securityGroupIds(exampleAwsSecurityGroup.stream().map(element -> element.id()).collect(toList()))
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DeviceFarm Test Grid Projects using their ARN. For example:
 * ```sh
 * $ pulumi import aws:devicefarm/testGridProject:TestGridProject example arn:aws:devicefarm:us-west-2:123456789012:testgrid-project:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 */
public class TestGridProject internal constructor(
    override val javaResource: com.pulumi.aws.devicefarm.TestGridProject,
) : KotlinCustomResource(javaResource, TestGridProjectMapper) {
    /**
     * The Amazon Resource Name of this Test Grid Project.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Human-readable description of the project.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Selenium testing project.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The VPC security groups and subnets that are attached to a project. See VPC Config below.
     */
    public val vpcConfig: Output<TestGridProjectVpcConfig>?
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object TestGridProjectMapper : ResourceMapper<TestGridProject> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devicefarm.TestGridProject::class == javaResource::class

    override fun map(javaResource: Resource): TestGridProject = TestGridProject(
        javaResource as
            com.pulumi.aws.devicefarm.TestGridProject,
    )
}

/**
 * @see [TestGridProject].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [TestGridProject].
 */
public suspend fun testGridProject(
    name: String,
    block: suspend TestGridProjectResourceBuilder.() -> Unit,
): TestGridProject {
    val builder = TestGridProjectResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [TestGridProject].
 * @param name The _unique_ name of the resulting resource.
 */
public fun testGridProject(name: String): TestGridProject {
    val builder = TestGridProjectResourceBuilder()
    builder.name(name)
    return builder.build()
}
