@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Upload].
 */
@PulumiTagMarker
public class UploadResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UploadArgs = UploadArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UploadArgsBuilder.() -> Unit) {
        val builder = UploadArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Upload {
        val builtJavaResource = com.pulumi.aws.devicefarm.Upload(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Upload(builtJavaResource)
    }
}

/**
 * Provides a resource to manage AWS Device Farm Uploads.
 * > **NOTE:** AWS currently has limited regional support for Device Farm (e.g., `us-west-2`). See [AWS Device Farm endpoints and quotas](https://docs.aws.amazon.com/general/latest/gr/devicefarm.html) for information on supported regions.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devicefarm.Project("example", {name: "example"});
 * const exampleUpload = new aws.devicefarm.Upload("example", {
 *     name: "example",
 *     projectArn: example.arn,
 *     type: "APPIUM_JAVA_TESTNG_TEST_SPEC",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devicefarm.Project("example", name="example")
 * example_upload = aws.devicefarm.Upload("example",
 *     name="example",
 *     project_arn=example.arn,
 *     type="APPIUM_JAVA_TESTNG_TEST_SPEC")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DeviceFarm.Project("example", new()
 *     {
 *         Name = "example",
 *     });
 *     var exampleUpload = new Aws.DeviceFarm.Upload("example", new()
 *     {
 *         Name = "example",
 *         ProjectArn = example.Arn,
 *         Type = "APPIUM_JAVA_TESTNG_TEST_SPEC",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devicefarm"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := devicefarm.NewProject(ctx, "example", &devicefarm.ProjectArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = devicefarm.NewUpload(ctx, "example", &devicefarm.UploadArgs{
 * 			Name:       pulumi.String("example"),
 * 			ProjectArn: example.Arn,
 * 			Type:       pulumi.String("APPIUM_JAVA_TESTNG_TEST_SPEC"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devicefarm.Project;
 * import com.pulumi.aws.devicefarm.ProjectArgs;
 * import com.pulumi.aws.devicefarm.Upload;
 * import com.pulumi.aws.devicefarm.UploadArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Project("example", ProjectArgs.builder()
 *             .name("example")
 *             .build());
 *         var exampleUpload = new Upload("exampleUpload", UploadArgs.builder()
 *             .name("example")
 *             .projectArn(example.arn())
 *             .type("APPIUM_JAVA_TESTNG_TEST_SPEC")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devicefarm:Project
 *     properties:
 *       name: example
 *   exampleUpload:
 *     type: aws:devicefarm:Upload
 *     name: example
 *     properties:
 *       name: example
 *       projectArn: ${example.arn}
 *       type: APPIUM_JAVA_TESTNG_TEST_SPEC
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DeviceFarm Uploads using their ARN. For example:
 * ```sh
 * $ pulumi import aws:devicefarm/upload:Upload example arn:aws:devicefarm:us-west-2:123456789012:upload:4fa784c7-ccb4-4dbf-ba4f-02198320daa1
 * ```
 */
public class Upload internal constructor(
    override val javaResource: com.pulumi.aws.devicefarm.Upload,
) : KotlinCustomResource(javaResource, UploadMapper) {
    /**
     * The Amazon Resource Name of this upload.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The upload's category.
     */
    public val category: Output<String>
        get() = javaResource.category().applyValue({ args0 -> args0 })

    /**
     * The upload's content type (for example, application/octet-stream).
     */
    public val contentType: Output<String>?
        get() = javaResource.contentType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The upload's metadata. For example, for Android, this contains information that is parsed from the manifest and is displayed in the AWS Device Farm console after the associated app is uploaded.
     */
    public val metadata: Output<String>
        get() = javaResource.metadata().applyValue({ args0 -> args0 })

    /**
     * The upload's file name. The name should not contain any forward slashes (/). If you are uploading an iOS app, the file name must end with the .ipa extension. If you are uploading an Android app, the file name must end with the .apk extension. For all others, the file name must end with the .zip file extension.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the project for the upload.
     */
    public val projectArn: Output<String>
        get() = javaResource.projectArn().applyValue({ args0 -> args0 })

    /**
     * The upload's upload type. See [AWS Docs](https://docs.aws.amazon.com/devicefarm/latest/APIReference/API_CreateUpload.html#API_CreateUpload_RequestSyntax) for valid list of values.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The presigned Amazon S3 URL that was used to store a file using a PUT request.
     */
    public val url: Output<String>
        get() = javaResource.url().applyValue({ args0 -> args0 })
}

public object UploadMapper : ResourceMapper<Upload> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devicefarm.Upload::class == javaResource::class

    override fun map(javaResource: Resource): Upload = Upload(
        javaResource as
            com.pulumi.aws.devicefarm.Upload,
    )
}

/**
 * @see [Upload].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Upload].
 */
public suspend fun upload(name: String, block: suspend UploadResourceBuilder.() -> Unit): Upload {
    val builder = UploadResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Upload].
 * @param name The _unique_ name of the resulting resource.
 */
public fun upload(name: String): Upload {
    val builder = UploadResourceBuilder()
    builder.name(name)
    return builder.build()
}
