@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devicefarm.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds A list of VPC security group IDs in your Amazon VPC.
 * @property subnetIds A list of VPC subnet IDs in your Amazon VPC.
 * @property vpcId The ID of the Amazon VPC.
 */
public data class TestGridProjectVpcConfig(
    public val securityGroupIds: List<String>,
    public val subnetIds: List<String>,
    public val vpcId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devicefarm.outputs.TestGridProjectVpcConfig): TestGridProjectVpcConfig = TestGridProjectVpcConfig(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            vpcId = javaType.vpcId(),
        )
    }
}
