@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.DevopsguruFunctions.getNotificationChannelPlain
import com.pulumi.aws.devopsguru.DevopsguruFunctions.getResourceCollectionPlain
import com.pulumi.aws.devopsguru.kotlin.inputs.GetNotificationChannelFilter
import com.pulumi.aws.devopsguru.kotlin.inputs.GetNotificationChannelPlainArgs
import com.pulumi.aws.devopsguru.kotlin.inputs.GetNotificationChannelPlainArgsBuilder
import com.pulumi.aws.devopsguru.kotlin.inputs.GetNotificationChannelSn
import com.pulumi.aws.devopsguru.kotlin.inputs.GetResourceCollectionCloudformation
import com.pulumi.aws.devopsguru.kotlin.inputs.GetResourceCollectionPlainArgs
import com.pulumi.aws.devopsguru.kotlin.inputs.GetResourceCollectionPlainArgsBuilder
import com.pulumi.aws.devopsguru.kotlin.inputs.GetResourceCollectionTag
import com.pulumi.aws.devopsguru.kotlin.outputs.GetNotificationChannelResult
import com.pulumi.aws.devopsguru.kotlin.outputs.GetResourceCollectionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.aws.devopsguru.kotlin.outputs.GetNotificationChannelResult.Companion.toKotlin as getNotificationChannelResultToKotlin
import com.pulumi.aws.devopsguru.kotlin.outputs.GetResourceCollectionResult.Companion.toKotlin as getResourceCollectionResultToKotlin

public object DevopsguruFunctions {
    /**
     * Data source for managing an AWS DevOps Guru Notification Channel.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.devopsguru.getNotificationChannel({
     *     id: "channel-1234",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.devopsguru.get_notification_channel(id="channel-1234")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.DevOpsGuru.GetNotificationChannel.Invoke(new()
     *     {
     *         Id = "channel-1234",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := devopsguru.LookupNotificationChannel(ctx, &devopsguru.LookupNotificationChannelArgs{
     * 			Id: "channel-1234",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.devopsguru.DevopsguruFunctions;
     * import com.pulumi.aws.devopsguru.inputs.GetNotificationChannelArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DevopsguruFunctions.getNotificationChannel(GetNotificationChannelArgs.builder()
     *             .id("channel-1234")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:devopsguru:getNotificationChannel
     *       Arguments:
     *         id: channel-1234
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNotificationChannel.
     * @return A collection of values returned by getNotificationChannel.
     */
    public suspend fun getNotificationChannel(argument: GetNotificationChannelPlainArgs): GetNotificationChannelResult =
        getNotificationChannelResultToKotlin(getNotificationChannelPlain(argument.toJava()).await())

    /**
     * @see [getNotificationChannel].
     * @param filters Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
     * @param id Unique identifier for the notification channel.
     * @param sns SNS noficiation channel configurations. See the `sns` attribute reference below.
     * @return A collection of values returned by getNotificationChannel.
     */
    public suspend fun getNotificationChannel(
        filters: List<GetNotificationChannelFilter>? = null,
        id: String,
        sns: List<GetNotificationChannelSn>? = null,
    ): GetNotificationChannelResult {
        val argument = GetNotificationChannelPlainArgs(
            filters = filters,
            id = id,
            sns = sns,
        )
        return getNotificationChannelResultToKotlin(getNotificationChannelPlain(argument.toJava()).await())
    }

    /**
     * @see [getNotificationChannel].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;devopsguru&#46;kotlin&#46;inputs&#46;GetNotificationChannelPlainArgs].
     * @return A collection of values returned by getNotificationChannel.
     */
    public suspend fun getNotificationChannel(argument: suspend GetNotificationChannelPlainArgsBuilder.() -> Unit): GetNotificationChannelResult {
        val builder = GetNotificationChannelPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNotificationChannelResultToKotlin(getNotificationChannelPlain(builtArgument.toJava()).await())
    }

    /**
     * Data source for managing an AWS DevOps Guru Resource Collection.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.devopsguru.getResourceCollection({
     *     type: "AWS_SERVICE",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.devopsguru.get_resource_collection(type="AWS_SERVICE")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.DevOpsGuru.GetResourceCollection.Invoke(new()
     *     {
     *         Type = "AWS_SERVICE",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := devopsguru.LookupResourceCollection(ctx, &devopsguru.LookupResourceCollectionArgs{
     * 			Type: "AWS_SERVICE",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.devopsguru.DevopsguruFunctions;
     * import com.pulumi.aws.devopsguru.inputs.GetResourceCollectionArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = DevopsguruFunctions.getResourceCollection(GetResourceCollectionArgs.builder()
     *             .type("AWS_SERVICE")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:devopsguru:getResourceCollection
     *       Arguments:
     *         type: AWS_SERVICE
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getResourceCollection.
     * @return A collection of values returned by getResourceCollection.
     */
    public suspend fun getResourceCollection(argument: GetResourceCollectionPlainArgs): GetResourceCollectionResult =
        getResourceCollectionResultToKotlin(getResourceCollectionPlain(argument.toJava()).await())

    /**
     * @see [getResourceCollection].
     * @param cloudformations A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     * @param tags AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     * @param type Type of AWS resource collection to create. Valid values are `AWS_CLOUD_FORMATION`, `AWS_SERVICE`, and `AWS_TAGS`.
     * @return A collection of values returned by getResourceCollection.
     */
    public suspend fun getResourceCollection(
        cloudformations: List<GetResourceCollectionCloudformation>? = null,
        tags: List<GetResourceCollectionTag>? = null,
        type: String,
    ): GetResourceCollectionResult {
        val argument = GetResourceCollectionPlainArgs(
            cloudformations = cloudformations,
            tags = tags,
            type = type,
        )
        return getResourceCollectionResultToKotlin(getResourceCollectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceCollection].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;devopsguru&#46;kotlin&#46;inputs&#46;GetResourceCollectionPlainArgs].
     * @return A collection of values returned by getResourceCollection.
     */
    public suspend fun getResourceCollection(argument: suspend GetResourceCollectionPlainArgsBuilder.() -> Unit): GetResourceCollectionResult {
        val builder = GetResourceCollectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceCollectionResultToKotlin(getResourceCollectionPlain(builtArgument.toJava()).await())
    }
}
