@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.kotlin.outputs.EventSourcesConfigEventSource
import com.pulumi.aws.devopsguru.kotlin.outputs.EventSourcesConfigEventSource.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [EventSourcesConfig].
 */
@PulumiTagMarker
public class EventSourcesConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: EventSourcesConfigArgs = EventSourcesConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend EventSourcesConfigArgsBuilder.() -> Unit) {
        val builder = EventSourcesConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): EventSourcesConfig {
        val builtJavaResource = com.pulumi.aws.devopsguru.EventSourcesConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return EventSourcesConfig(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.EventSourcesConfig("example", {eventSources: [{
 *     amazonCodeGuruProfilers: [{
 *         status: "ENABLED",
 *     }],
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.EventSourcesConfig("example", event_sources=[{
 *     "amazon_code_guru_profilers": [{
 *         "status": "ENABLED",
 *     }],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.EventSourcesConfig("example", new()
 *     {
 *         EventSources = new[]
 *         {
 *             new Aws.DevOpsGuru.Inputs.EventSourcesConfigEventSourceArgs
 *             {
 *                 AmazonCodeGuruProfilers = new[]
 *                 {
 *                     new Aws.DevOpsGuru.Inputs.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs
 *                     {
 *                         Status = "ENABLED",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewEventSourcesConfig(ctx, "example", &devopsguru.EventSourcesConfigArgs{
 * 			EventSources: devopsguru.EventSourcesConfigEventSourceArray{
 * 				&devopsguru.EventSourcesConfigEventSourceArgs{
 * 					AmazonCodeGuruProfilers: devopsguru.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArray{
 * 						&devopsguru.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs{
 * 							Status: pulumi.String("ENABLED"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.EventSourcesConfig;
 * import com.pulumi.aws.devopsguru.EventSourcesConfigArgs;
 * import com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourcesConfig("example", EventSourcesConfigArgs.builder()
 *             .eventSources(EventSourcesConfigEventSourceArgs.builder()
 *                 .amazonCodeGuruProfilers(EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs.builder()
 *                     .status("ENABLED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:EventSourcesConfig
 *     properties:
 *       eventSources:
 *         - amazonCodeGuruProfilers:
 *             - status: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DevOps Guru Event Sources Config using the `id`. For example:
 * ```sh
 * $ pulumi import aws:devopsguru/eventSourcesConfig:EventSourcesConfig example us-east-1
 * ```
 */
public class EventSourcesConfig internal constructor(
    override val javaResource: com.pulumi.aws.devopsguru.EventSourcesConfig,
) : KotlinCustomResource(javaResource, EventSourcesConfigMapper) {
    /**
     * Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    public val eventSources: Output<List<EventSourcesConfigEventSource>>?
        get() = javaResource.eventSources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })
}

public object EventSourcesConfigMapper : ResourceMapper<EventSourcesConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devopsguru.EventSourcesConfig::class == javaResource::class

    override fun map(javaResource: Resource): EventSourcesConfig = EventSourcesConfig(
        javaResource as
            com.pulumi.aws.devopsguru.EventSourcesConfig,
    )
}

/**
 * @see [EventSourcesConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [EventSourcesConfig].
 */
public suspend fun eventSourcesConfig(
    name: String,
    block: suspend EventSourcesConfigResourceBuilder.() -> Unit,
): EventSourcesConfig {
    val builder = EventSourcesConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [EventSourcesConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun eventSourcesConfig(name: String): EventSourcesConfig {
    val builder = EventSourcesConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
