@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.EventSourcesConfigArgs.builder
import com.pulumi.aws.devopsguru.kotlin.inputs.EventSourcesConfigEventSourceArgs
import com.pulumi.aws.devopsguru.kotlin.inputs.EventSourcesConfigEventSourceArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.EventSourcesConfig("example", {eventSources: [{
 *     amazonCodeGuruProfilers: [{
 *         status: "ENABLED",
 *     }],
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.EventSourcesConfig("example", event_sources=[{
 *     "amazon_code_guru_profilers": [{
 *         "status": "ENABLED",
 *     }],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.EventSourcesConfig("example", new()
 *     {
 *         EventSources = new[]
 *         {
 *             new Aws.DevOpsGuru.Inputs.EventSourcesConfigEventSourceArgs
 *             {
 *                 AmazonCodeGuruProfilers = new[]
 *                 {
 *                     new Aws.DevOpsGuru.Inputs.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs
 *                     {
 *                         Status = "ENABLED",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewEventSourcesConfig(ctx, "example", &devopsguru.EventSourcesConfigArgs{
 * 			EventSources: devopsguru.EventSourcesConfigEventSourceArray{
 * 				&devopsguru.EventSourcesConfigEventSourceArgs{
 * 					AmazonCodeGuruProfilers: devopsguru.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArray{
 * 						&devopsguru.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs{
 * 							Status: pulumi.String("ENABLED"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.EventSourcesConfig;
 * import com.pulumi.aws.devopsguru.EventSourcesConfigArgs;
 * import com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new EventSourcesConfig("example", EventSourcesConfigArgs.builder()
 *             .eventSources(EventSourcesConfigEventSourceArgs.builder()
 *                 .amazonCodeGuruProfilers(EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs.builder()
 *                     .status("ENABLED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:EventSourcesConfig
 *     properties:
 *       eventSources:
 *         - amazonCodeGuruProfilers:
 *             - status: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DevOps Guru Event Sources Config using the `id`. For example:
 * ```sh
 * $ pulumi import aws:devopsguru/eventSourcesConfig:EventSourcesConfig example us-east-1
 * ```
 * @property eventSources Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
 */
public data class EventSourcesConfigArgs(
    public val eventSources: Output<List<EventSourcesConfigEventSourceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.EventSourcesConfigArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.EventSourcesConfigArgs =
        com.pulumi.aws.devopsguru.EventSourcesConfigArgs.builder()
            .eventSources(
                eventSources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventSourcesConfigArgs].
 */
@PulumiTagMarker
public class EventSourcesConfigArgsBuilder internal constructor() {
    private var eventSources: Output<List<EventSourcesConfigEventSourceArgs>>? = null

    /**
     * @param value Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    @JvmName("cgvnvnmhbulagvtl")
    public suspend fun eventSources(`value`: Output<List<EventSourcesConfigEventSourceArgs>>) {
        this.eventSources = value
    }

    @JvmName("ssmjwqunxlixuwmo")
    public suspend fun eventSources(vararg values: Output<EventSourcesConfigEventSourceArgs>) {
        this.eventSources = Output.all(values.asList())
    }

    /**
     * @param values Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    @JvmName("rcngtburtlmvnsae")
    public suspend fun eventSources(values: List<Output<EventSourcesConfigEventSourceArgs>>) {
        this.eventSources = Output.all(values)
    }

    /**
     * @param value Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    @JvmName("piuwbtnmwexrnpqc")
    public suspend fun eventSources(`value`: List<EventSourcesConfigEventSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSources = mapped
    }

    /**
     * @param argument Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    @JvmName("iabnqguitiycqmrp")
    public suspend fun eventSources(argument: List<suspend EventSourcesConfigEventSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventSourcesConfigEventSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSources = mapped
    }

    /**
     * @param argument Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    @JvmName("eutjovcafvonkyhd")
    public suspend fun eventSources(vararg argument: suspend EventSourcesConfigEventSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventSourcesConfigEventSourceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.eventSources = mapped
    }

    /**
     * @param argument Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    @JvmName("xdppnnkniptnycqk")
    public suspend fun eventSources(argument: suspend EventSourcesConfigEventSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            EventSourcesConfigEventSourceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.eventSources = mapped
    }

    /**
     * @param values Configuration information about the integration of DevOps Guru as the Consumer via EventBridge with another AWS Service. See `event_sources` below.
     */
    @JvmName("bgdoymgyalukorxn")
    public suspend fun eventSources(vararg values: EventSourcesConfigEventSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventSources = mapped
    }

    internal fun build(): EventSourcesConfigArgs = EventSourcesConfigArgs(
        eventSources = eventSources,
    )
}
