@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.kotlin.outputs.NotificationChannelFilters
import com.pulumi.aws.devopsguru.kotlin.outputs.NotificationChannelSns
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.devopsguru.kotlin.outputs.NotificationChannelFilters.Companion.toKotlin as notificationChannelFiltersToKotlin
import com.pulumi.aws.devopsguru.kotlin.outputs.NotificationChannelSns.Companion.toKotlin as notificationChannelSnsToKotlin

/**
 * Builder for [NotificationChannel].
 */
@PulumiTagMarker
public class NotificationChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NotificationChannelArgs = NotificationChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NotificationChannelArgsBuilder.() -> Unit) {
        val builder = NotificationChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NotificationChannel {
        val builtJavaResource = com.pulumi.aws.devopsguru.NotificationChannel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return NotificationChannel(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS DevOps Guru Notification Channel.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.NotificationChannel("example", {sns: {
 *     topicArn: exampleAwsSnsTopic.arn,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.NotificationChannel("example", sns={
 *     "topic_arn": example_aws_sns_topic["arn"],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.NotificationChannel("example", new()
 *     {
 *         Sns = new Aws.DevOpsGuru.Inputs.NotificationChannelSnsArgs
 *         {
 *             TopicArn = exampleAwsSnsTopic.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewNotificationChannel(ctx, "example", &devopsguru.NotificationChannelArgs{
 * 			Sns: &devopsguru.NotificationChannelSnsArgs{
 * 				TopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.NotificationChannel;
 * import com.pulumi.aws.devopsguru.NotificationChannelArgs;
 * import com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NotificationChannel("example", NotificationChannelArgs.builder()
 *             .sns(NotificationChannelSnsArgs.builder()
 *                 .topicArn(exampleAwsSnsTopic.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:NotificationChannel
 *     properties:
 *       sns:
 *         topicArn: ${exampleAwsSnsTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Filters
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.NotificationChannel("example", {
 *     sns: {
 *         topicArn: exampleAwsSnsTopic.arn,
 *     },
 *     filters: {
 *         messageTypes: ["NEW_INSIGHT"],
 *         severities: ["HIGH"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.NotificationChannel("example",
 *     sns={
 *         "topic_arn": example_aws_sns_topic["arn"],
 *     },
 *     filters={
 *         "message_types": ["NEW_INSIGHT"],
 *         "severities": ["HIGH"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.NotificationChannel("example", new()
 *     {
 *         Sns = new Aws.DevOpsGuru.Inputs.NotificationChannelSnsArgs
 *         {
 *             TopicArn = exampleAwsSnsTopic.Arn,
 *         },
 *         Filters = new Aws.DevOpsGuru.Inputs.NotificationChannelFiltersArgs
 *         {
 *             MessageTypes = new[]
 *             {
 *                 "NEW_INSIGHT",
 *             },
 *             Severities = new[]
 *             {
 *                 "HIGH",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewNotificationChannel(ctx, "example", &devopsguru.NotificationChannelArgs{
 * 			Sns: &devopsguru.NotificationChannelSnsArgs{
 * 				TopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			},
 * 			Filters: &devopsguru.NotificationChannelFiltersArgs{
 * 				MessageTypes: pulumi.StringArray{
 * 					pulumi.String("NEW_INSIGHT"),
 * 				},
 * 				Severities: pulumi.StringArray{
 * 					pulumi.String("HIGH"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.NotificationChannel;
 * import com.pulumi.aws.devopsguru.NotificationChannelArgs;
 * import com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs;
 * import com.pulumi.aws.devopsguru.inputs.NotificationChannelFiltersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NotificationChannel("example", NotificationChannelArgs.builder()
 *             .sns(NotificationChannelSnsArgs.builder()
 *                 .topicArn(exampleAwsSnsTopic.arn())
 *                 .build())
 *             .filters(NotificationChannelFiltersArgs.builder()
 *                 .messageTypes("NEW_INSIGHT")
 *                 .severities("HIGH")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:NotificationChannel
 *     properties:
 *       sns:
 *         topicArn: ${exampleAwsSnsTopic.arn}
 *       filters:
 *         messageTypes:
 *           - NEW_INSIGHT
 *         severities:
 *           - HIGH
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DevOps Guru Notification Channel using the `id`. For example:
 * ```sh
 * $ pulumi import aws:devopsguru/notificationChannel:NotificationChannel example id-12345678
 * ```
 */
public class NotificationChannel internal constructor(
    override val javaResource: com.pulumi.aws.devopsguru.NotificationChannel,
) : KotlinCustomResource(javaResource, NotificationChannelMapper) {
    /**
     * Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
     */
    public val filters: Output<NotificationChannelFilters>?
        get() = javaResource.filters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    notificationChannelFiltersToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * SNS noficiation channel configurations. See the `sns` argument reference below.
     * The following arguments are optional:
     */
    public val sns: Output<NotificationChannelSns>?
        get() = javaResource.sns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    notificationChannelSnsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object NotificationChannelMapper : ResourceMapper<NotificationChannel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devopsguru.NotificationChannel::class == javaResource::class

    override fun map(javaResource: Resource): NotificationChannel = NotificationChannel(
        javaResource
            as com.pulumi.aws.devopsguru.NotificationChannel,
    )
}

/**
 * @see [NotificationChannel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NotificationChannel].
 */
public suspend fun notificationChannel(
    name: String,
    block: suspend NotificationChannelResourceBuilder.() -> Unit,
): NotificationChannel {
    val builder = NotificationChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NotificationChannel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun notificationChannel(name: String): NotificationChannel {
    val builder = NotificationChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
