@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.NotificationChannelArgs.builder
import com.pulumi.aws.devopsguru.kotlin.inputs.NotificationChannelFiltersArgs
import com.pulumi.aws.devopsguru.kotlin.inputs.NotificationChannelFiltersArgsBuilder
import com.pulumi.aws.devopsguru.kotlin.inputs.NotificationChannelSnsArgs
import com.pulumi.aws.devopsguru.kotlin.inputs.NotificationChannelSnsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS DevOps Guru Notification Channel.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.NotificationChannel("example", {sns: {
 *     topicArn: exampleAwsSnsTopic.arn,
 * }});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.NotificationChannel("example", sns={
 *     "topic_arn": example_aws_sns_topic["arn"],
 * })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.NotificationChannel("example", new()
 *     {
 *         Sns = new Aws.DevOpsGuru.Inputs.NotificationChannelSnsArgs
 *         {
 *             TopicArn = exampleAwsSnsTopic.Arn,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewNotificationChannel(ctx, "example", &devopsguru.NotificationChannelArgs{
 * 			Sns: &devopsguru.NotificationChannelSnsArgs{
 * 				TopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.NotificationChannel;
 * import com.pulumi.aws.devopsguru.NotificationChannelArgs;
 * import com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NotificationChannel("example", NotificationChannelArgs.builder()
 *             .sns(NotificationChannelSnsArgs.builder()
 *                 .topicArn(exampleAwsSnsTopic.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:NotificationChannel
 *     properties:
 *       sns:
 *         topicArn: ${exampleAwsSnsTopic.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Filters
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.NotificationChannel("example", {
 *     sns: {
 *         topicArn: exampleAwsSnsTopic.arn,
 *     },
 *     filters: {
 *         messageTypes: ["NEW_INSIGHT"],
 *         severities: ["HIGH"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.NotificationChannel("example",
 *     sns={
 *         "topic_arn": example_aws_sns_topic["arn"],
 *     },
 *     filters={
 *         "message_types": ["NEW_INSIGHT"],
 *         "severities": ["HIGH"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.NotificationChannel("example", new()
 *     {
 *         Sns = new Aws.DevOpsGuru.Inputs.NotificationChannelSnsArgs
 *         {
 *             TopicArn = exampleAwsSnsTopic.Arn,
 *         },
 *         Filters = new Aws.DevOpsGuru.Inputs.NotificationChannelFiltersArgs
 *         {
 *             MessageTypes = new[]
 *             {
 *                 "NEW_INSIGHT",
 *             },
 *             Severities = new[]
 *             {
 *                 "HIGH",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewNotificationChannel(ctx, "example", &devopsguru.NotificationChannelArgs{
 * 			Sns: &devopsguru.NotificationChannelSnsArgs{
 * 				TopicArn: pulumi.Any(exampleAwsSnsTopic.Arn),
 * 			},
 * 			Filters: &devopsguru.NotificationChannelFiltersArgs{
 * 				MessageTypes: pulumi.StringArray{
 * 					pulumi.String("NEW_INSIGHT"),
 * 				},
 * 				Severities: pulumi.StringArray{
 * 					pulumi.String("HIGH"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.NotificationChannel;
 * import com.pulumi.aws.devopsguru.NotificationChannelArgs;
 * import com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs;
 * import com.pulumi.aws.devopsguru.inputs.NotificationChannelFiltersArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new NotificationChannel("example", NotificationChannelArgs.builder()
 *             .sns(NotificationChannelSnsArgs.builder()
 *                 .topicArn(exampleAwsSnsTopic.arn())
 *                 .build())
 *             .filters(NotificationChannelFiltersArgs.builder()
 *                 .messageTypes("NEW_INSIGHT")
 *                 .severities("HIGH")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:NotificationChannel
 *     properties:
 *       sns:
 *         topicArn: ${exampleAwsSnsTopic.arn}
 *       filters:
 *         messageTypes:
 *           - NEW_INSIGHT
 *         severities:
 *           - HIGH
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DevOps Guru Notification Channel using the `id`. For example:
 * ```sh
 * $ pulumi import aws:devopsguru/notificationChannel:NotificationChannel example id-12345678
 * ```
 * @property filters Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
 * @property sns SNS noficiation channel configurations. See the `sns` argument reference below.
 * The following arguments are optional:
 */
public data class NotificationChannelArgs(
    public val filters: Output<NotificationChannelFiltersArgs>? = null,
    public val sns: Output<NotificationChannelSnsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.NotificationChannelArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.NotificationChannelArgs =
        com.pulumi.aws.devopsguru.NotificationChannelArgs.builder()
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sns(sns?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NotificationChannelArgs].
 */
@PulumiTagMarker
public class NotificationChannelArgsBuilder internal constructor() {
    private var filters: Output<NotificationChannelFiltersArgs>? = null

    private var sns: Output<NotificationChannelSnsArgs>? = null

    /**
     * @param value Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
     */
    @JvmName("rxcgplpiwgriitrs")
    public suspend fun filters(`value`: Output<NotificationChannelFiltersArgs>) {
        this.filters = value
    }

    /**
     * @param value SNS noficiation channel configurations. See the `sns` argument reference below.
     * The following arguments are optional:
     */
    @JvmName("biguhbnxjnouxyxt")
    public suspend fun sns(`value`: Output<NotificationChannelSnsArgs>) {
        this.sns = value
    }

    /**
     * @param value Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
     */
    @JvmName("nqqyuqmsffvnbdcd")
    public suspend fun filters(`value`: NotificationChannelFiltersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument Filter configurations for the Amazon SNS notification topic. See the `filters` argument reference below.
     */
    @JvmName("lxhlcioxwairvprp")
    public suspend fun filters(argument: suspend NotificationChannelFiltersArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationChannelFiltersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value SNS noficiation channel configurations. See the `sns` argument reference below.
     * The following arguments are optional:
     */
    @JvmName("mcqenmblfbokjene")
    public suspend fun sns(`value`: NotificationChannelSnsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sns = mapped
    }

    /**
     * @param argument SNS noficiation channel configurations. See the `sns` argument reference below.
     * The following arguments are optional:
     */
    @JvmName("qxxrcmedlrpkcfhv")
    public suspend fun sns(argument: suspend NotificationChannelSnsArgsBuilder.() -> Unit) {
        val toBeMapped = NotificationChannelSnsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sns = mapped
    }

    internal fun build(): NotificationChannelArgs = NotificationChannelArgs(
        filters = filters,
        sns = sns,
    )
}
