@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.kotlin.outputs.ResourceCollectionCloudformation
import com.pulumi.aws.devopsguru.kotlin.outputs.ResourceCollectionTags
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.devopsguru.kotlin.outputs.ResourceCollectionCloudformation.Companion.toKotlin as resourceCollectionCloudformationToKotlin
import com.pulumi.aws.devopsguru.kotlin.outputs.ResourceCollectionTags.Companion.toKotlin as resourceCollectionTagsToKotlin

/**
 * Builder for [ResourceCollection].
 */
@PulumiTagMarker
public class ResourceCollectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceCollectionArgs = ResourceCollectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceCollectionArgsBuilder.() -> Unit) {
        val builder = ResourceCollectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceCollection {
        val builtJavaResource = com.pulumi.aws.devopsguru.ResourceCollection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceCollection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS DevOps Guru Resource Collection.
 * > Only one type of resource collection (All Account Resources, CloudFormation, or Tags) can be enabled in an account at a time. To avoid persistent differences, this resource should be defined only once.
 * ## Example Usage
 * ### All Account Resources
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_SERVICE",
 *     cloudformation: {
 *         stackNames: ["*"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_SERVICE",
 *     cloudformation={
 *         "stack_names": ["*"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_SERVICE",
 *         Cloudformation = new Aws.DevOpsGuru.Inputs.ResourceCollectionCloudformationArgs
 *         {
 *             StackNames = new[]
 *             {
 *                 "*",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_SERVICE"),
 * 			Cloudformation: &devopsguru.ResourceCollectionCloudformationArgs{
 * 				StackNames: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_SERVICE")
 *             .cloudformation(ResourceCollectionCloudformationArgs.builder()
 *                 .stackNames("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_SERVICE
 *       cloudformation:
 *         stackNames:
 *           - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### CloudFormation Stacks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_CLOUD_FORMATION",
 *     cloudformation: {
 *         stackNames: ["ExampleStack"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_CLOUD_FORMATION",
 *     cloudformation={
 *         "stack_names": ["ExampleStack"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_CLOUD_FORMATION",
 *         Cloudformation = new Aws.DevOpsGuru.Inputs.ResourceCollectionCloudformationArgs
 *         {
 *             StackNames = new[]
 *             {
 *                 "ExampleStack",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_CLOUD_FORMATION"),
 * 			Cloudformation: &devopsguru.ResourceCollectionCloudformationArgs{
 * 				StackNames: pulumi.StringArray{
 * 					pulumi.String("ExampleStack"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_CLOUD_FORMATION")
 *             .cloudformation(ResourceCollectionCloudformationArgs.builder()
 *                 .stackNames("ExampleStack")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_CLOUD_FORMATION
 *       cloudformation:
 *         stackNames:
 *           - ExampleStack
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_TAGS",
 *     tags: {
 *         appBoundaryKey: "DevOps-Guru-Example",
 *         tagValues: ["Example-Value"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_TAGS",
 *     tags={
 *         "app_boundary_key": "DevOps-Guru-Example",
 *         "tag_values": ["Example-Value"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_TAGS",
 *         Tags = new Aws.DevOpsGuru.Inputs.ResourceCollectionTagsArgs
 *         {
 *             AppBoundaryKey = "DevOps-Guru-Example",
 *             TagValues = new[]
 *             {
 *                 "Example-Value",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_TAGS"),
 * 			Tags: &devopsguru.ResourceCollectionTagsArgs{
 * 				AppBoundaryKey: pulumi.String("DevOps-Guru-Example"),
 * 				TagValues: pulumi.StringArray{
 * 					pulumi.String("Example-Value"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_TAGS")
 *             .tags(ResourceCollectionTagsArgs.builder()
 *                 .appBoundaryKey("DevOps-Guru-Example")
 *                 .tagValues("Example-Value")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_TAGS
 *       tags:
 *         appBoundaryKey: DevOps-Guru-Example
 *         tagValues:
 *           - Example-Value
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Tags All Resources
 * To analyze all resources with the `app_boundary_key` regardless of the corresponding tag value, set `tag_values` to `["*"]`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_TAGS",
 *     tags: {
 *         appBoundaryKey: "DevOps-Guru-Example",
 *         tagValues: ["*"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_TAGS",
 *     tags={
 *         "app_boundary_key": "DevOps-Guru-Example",
 *         "tag_values": ["*"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_TAGS",
 *         Tags = new Aws.DevOpsGuru.Inputs.ResourceCollectionTagsArgs
 *         {
 *             AppBoundaryKey = "DevOps-Guru-Example",
 *             TagValues = new[]
 *             {
 *                 "*",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_TAGS"),
 * 			Tags: &devopsguru.ResourceCollectionTagsArgs{
 * 				AppBoundaryKey: pulumi.String("DevOps-Guru-Example"),
 * 				TagValues: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_TAGS")
 *             .tags(ResourceCollectionTagsArgs.builder()
 *                 .appBoundaryKey("DevOps-Guru-Example")
 *                 .tagValues("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_TAGS
 *       tags:
 *         appBoundaryKey: DevOps-Guru-Example
 *         tagValues:
 *           - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DevOps Guru Resource Collection using the `id`. For example:
 * ```sh
 * $ pulumi import aws:devopsguru/resourceCollection:ResourceCollection example AWS_CLOUD_FORMATION
 * ```
 */
public class ResourceCollection internal constructor(
    override val javaResource: com.pulumi.aws.devopsguru.ResourceCollection,
) : KotlinCustomResource(javaResource, ResourceCollectionMapper) {
    /**
     * A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    public val cloudformation: Output<ResourceCollectionCloudformation>?
        get() = javaResource.cloudformation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> resourceCollectionCloudformationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    public val tags: Output<ResourceCollectionTags>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceCollectionTagsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Type of AWS resource collection to create. Valid values are `AWS_CLOUD_FORMATION`, `AWS_SERVICE`, and `AWS_TAGS`.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceCollectionMapper : ResourceMapper<ResourceCollection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devopsguru.ResourceCollection::class == javaResource::class

    override fun map(javaResource: Resource): ResourceCollection = ResourceCollection(
        javaResource as
            com.pulumi.aws.devopsguru.ResourceCollection,
    )
}

/**
 * @see [ResourceCollection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceCollection].
 */
public suspend fun resourceCollection(
    name: String,
    block: suspend ResourceCollectionResourceBuilder.() -> Unit,
): ResourceCollection {
    val builder = ResourceCollectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceCollection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceCollection(name: String): ResourceCollection {
    val builder = ResourceCollectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
