@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.ResourceCollectionArgs.builder
import com.pulumi.aws.devopsguru.kotlin.inputs.ResourceCollectionCloudformationArgs
import com.pulumi.aws.devopsguru.kotlin.inputs.ResourceCollectionCloudformationArgsBuilder
import com.pulumi.aws.devopsguru.kotlin.inputs.ResourceCollectionTagsArgs
import com.pulumi.aws.devopsguru.kotlin.inputs.ResourceCollectionTagsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS DevOps Guru Resource Collection.
 * > Only one type of resource collection (All Account Resources, CloudFormation, or Tags) can be enabled in an account at a time. To avoid persistent differences, this resource should be defined only once.
 * ## Example Usage
 * ### All Account Resources
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_SERVICE",
 *     cloudformation: {
 *         stackNames: ["*"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_SERVICE",
 *     cloudformation={
 *         "stack_names": ["*"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_SERVICE",
 *         Cloudformation = new Aws.DevOpsGuru.Inputs.ResourceCollectionCloudformationArgs
 *         {
 *             StackNames = new[]
 *             {
 *                 "*",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_SERVICE"),
 * 			Cloudformation: &devopsguru.ResourceCollectionCloudformationArgs{
 * 				StackNames: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_SERVICE")
 *             .cloudformation(ResourceCollectionCloudformationArgs.builder()
 *                 .stackNames("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_SERVICE
 *       cloudformation:
 *         stackNames:
 *           - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### CloudFormation Stacks
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_CLOUD_FORMATION",
 *     cloudformation: {
 *         stackNames: ["ExampleStack"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_CLOUD_FORMATION",
 *     cloudformation={
 *         "stack_names": ["ExampleStack"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_CLOUD_FORMATION",
 *         Cloudformation = new Aws.DevOpsGuru.Inputs.ResourceCollectionCloudformationArgs
 *         {
 *             StackNames = new[]
 *             {
 *                 "ExampleStack",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_CLOUD_FORMATION"),
 * 			Cloudformation: &devopsguru.ResourceCollectionCloudformationArgs{
 * 				StackNames: pulumi.StringArray{
 * 					pulumi.String("ExampleStack"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_CLOUD_FORMATION")
 *             .cloudformation(ResourceCollectionCloudformationArgs.builder()
 *                 .stackNames("ExampleStack")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_CLOUD_FORMATION
 *       cloudformation:
 *         stackNames:
 *           - ExampleStack
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_TAGS",
 *     tags: {
 *         appBoundaryKey: "DevOps-Guru-Example",
 *         tagValues: ["Example-Value"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_TAGS",
 *     tags={
 *         "app_boundary_key": "DevOps-Guru-Example",
 *         "tag_values": ["Example-Value"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_TAGS",
 *         Tags = new Aws.DevOpsGuru.Inputs.ResourceCollectionTagsArgs
 *         {
 *             AppBoundaryKey = "DevOps-Guru-Example",
 *             TagValues = new[]
 *             {
 *                 "Example-Value",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_TAGS"),
 * 			Tags: &devopsguru.ResourceCollectionTagsArgs{
 * 				AppBoundaryKey: pulumi.String("DevOps-Guru-Example"),
 * 				TagValues: pulumi.StringArray{
 * 					pulumi.String("Example-Value"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_TAGS")
 *             .tags(ResourceCollectionTagsArgs.builder()
 *                 .appBoundaryKey("DevOps-Guru-Example")
 *                 .tagValues("Example-Value")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_TAGS
 *       tags:
 *         appBoundaryKey: DevOps-Guru-Example
 *         tagValues:
 *           - Example-Value
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Tags All Resources
 * To analyze all resources with the `app_boundary_key` regardless of the corresponding tag value, set `tag_values` to `["*"]`.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ResourceCollection("example", {
 *     type: "AWS_TAGS",
 *     tags: {
 *         appBoundaryKey: "DevOps-Guru-Example",
 *         tagValues: ["*"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ResourceCollection("example",
 *     type="AWS_TAGS",
 *     tags={
 *         "app_boundary_key": "DevOps-Guru-Example",
 *         "tag_values": ["*"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ResourceCollection("example", new()
 *     {
 *         Type = "AWS_TAGS",
 *         Tags = new Aws.DevOpsGuru.Inputs.ResourceCollectionTagsArgs
 *         {
 *             AppBoundaryKey = "DevOps-Guru-Example",
 *             TagValues = new[]
 *             {
 *                 "*",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewResourceCollection(ctx, "example", &devopsguru.ResourceCollectionArgs{
 * 			Type: pulumi.String("AWS_TAGS"),
 * 			Tags: &devopsguru.ResourceCollectionTagsArgs{
 * 				AppBoundaryKey: pulumi.String("DevOps-Guru-Example"),
 * 				TagValues: pulumi.StringArray{
 * 					pulumi.String("*"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ResourceCollection;
 * import com.pulumi.aws.devopsguru.ResourceCollectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceCollection("example", ResourceCollectionArgs.builder()
 *             .type("AWS_TAGS")
 *             .tags(ResourceCollectionTagsArgs.builder()
 *                 .appBoundaryKey("DevOps-Guru-Example")
 *                 .tagValues("*")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ResourceCollection
 *     properties:
 *       type: AWS_TAGS
 *       tags:
 *         appBoundaryKey: DevOps-Guru-Example
 *         tagValues:
 *           - '*'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DevOps Guru Resource Collection using the `id`. For example:
 * ```sh
 * $ pulumi import aws:devopsguru/resourceCollection:ResourceCollection example AWS_CLOUD_FORMATION
 * ```
 * @property cloudformation A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
 * @property tags AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
 * @property type Type of AWS resource collection to create. Valid values are `AWS_CLOUD_FORMATION`, `AWS_SERVICE`, and `AWS_TAGS`.
 * The following arguments are optional:
 */
public data class ResourceCollectionArgs(
    public val cloudformation: Output<ResourceCollectionCloudformationArgs>? = null,
    public val tags: Output<ResourceCollectionTagsArgs>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.ResourceCollectionArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.ResourceCollectionArgs =
        com.pulumi.aws.devopsguru.ResourceCollectionArgs.builder()
            .cloudformation(cloudformation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceCollectionArgs].
 */
@PulumiTagMarker
public class ResourceCollectionArgsBuilder internal constructor() {
    private var cloudformation: Output<ResourceCollectionCloudformationArgs>? = null

    private var tags: Output<ResourceCollectionTagsArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("elyifjefgeulovfi")
    public suspend fun cloudformation(`value`: Output<ResourceCollectionCloudformationArgs>) {
        this.cloudformation = value
    }

    /**
     * @param value AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("aixqkwqumxcejlwl")
    public suspend fun tags(`value`: Output<ResourceCollectionTagsArgs>) {
        this.tags = value
    }

    /**
     * @param value Type of AWS resource collection to create. Valid values are `AWS_CLOUD_FORMATION`, `AWS_SERVICE`, and `AWS_TAGS`.
     * The following arguments are optional:
     */
    @JvmName("cowkgdtkmoklptsc")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("pqtsscuamjpxhwbw")
    public suspend fun cloudformation(`value`: ResourceCollectionCloudformationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudformation = mapped
    }

    /**
     * @param argument A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("oywadvkxsqqbxfvq")
    public suspend fun cloudformation(argument: suspend ResourceCollectionCloudformationArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceCollectionCloudformationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.cloudformation = mapped
    }

    /**
     * @param value AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("gelupiloavupkrah")
    public suspend fun tags(`value`: ResourceCollectionTagsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("lbuctwcjoxbokrro")
    public suspend fun tags(argument: suspend ResourceCollectionTagsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceCollectionTagsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param value Type of AWS resource collection to create. Valid values are `AWS_CLOUD_FORMATION`, `AWS_SERVICE`, and `AWS_TAGS`.
     * The following arguments are optional:
     */
    @JvmName("yefqnevpighohmao")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResourceCollectionArgs = ResourceCollectionArgs(
        cloudformation = cloudformation,
        tags = tags,
        type = type,
    )
}
