@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin

import com.pulumi.aws.devopsguru.kotlin.outputs.ServiceIntegrationKmsServerSideEncryption
import com.pulumi.aws.devopsguru.kotlin.outputs.ServiceIntegrationLogsAnomalyDetection
import com.pulumi.aws.devopsguru.kotlin.outputs.ServiceIntegrationOpsCenter
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.aws.devopsguru.kotlin.outputs.ServiceIntegrationKmsServerSideEncryption.Companion.toKotlin as serviceIntegrationKmsServerSideEncryptionToKotlin
import com.pulumi.aws.devopsguru.kotlin.outputs.ServiceIntegrationLogsAnomalyDetection.Companion.toKotlin as serviceIntegrationLogsAnomalyDetectionToKotlin
import com.pulumi.aws.devopsguru.kotlin.outputs.ServiceIntegrationOpsCenter.Companion.toKotlin as serviceIntegrationOpsCenterToKotlin

/**
 * Builder for [ServiceIntegration].
 */
@PulumiTagMarker
public class ServiceIntegrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceIntegrationArgs = ServiceIntegrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceIntegrationArgsBuilder.() -> Unit) {
        val builder = ServiceIntegrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ServiceIntegration {
        val builtJavaResource = com.pulumi.aws.devopsguru.ServiceIntegration(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ServiceIntegration(builtJavaResource)
    }
}

/**
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.devopsguru.ServiceIntegration("example", {
 *     kmsServerSideEncryption: {
 *         optInStatus: "ENABLED",
 *         type: "AWS_OWNED_KMS_KEY",
 *     },
 *     logsAnomalyDetection: {
 *         optInStatus: "ENABLED",
 *     },
 *     opsCenter: {
 *         optInStatus: "ENABLED",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.devopsguru.ServiceIntegration("example",
 *     kms_server_side_encryption={
 *         "opt_in_status": "ENABLED",
 *         "type": "AWS_OWNED_KMS_KEY",
 *     },
 *     logs_anomaly_detection={
 *         "opt_in_status": "ENABLED",
 *     },
 *     ops_center={
 *         "opt_in_status": "ENABLED",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DevOpsGuru.ServiceIntegration("example", new()
 *     {
 *         KmsServerSideEncryption = new Aws.DevOpsGuru.Inputs.ServiceIntegrationKmsServerSideEncryptionArgs
 *         {
 *             OptInStatus = "ENABLED",
 *             Type = "AWS_OWNED_KMS_KEY",
 *         },
 *         LogsAnomalyDetection = new Aws.DevOpsGuru.Inputs.ServiceIntegrationLogsAnomalyDetectionArgs
 *         {
 *             OptInStatus = "ENABLED",
 *         },
 *         OpsCenter = new Aws.DevOpsGuru.Inputs.ServiceIntegrationOpsCenterArgs
 *         {
 *             OptInStatus = "ENABLED",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devopsguru.NewServiceIntegration(ctx, "example", &devopsguru.ServiceIntegrationArgs{
 * 			KmsServerSideEncryption: &devopsguru.ServiceIntegrationKmsServerSideEncryptionArgs{
 * 				OptInStatus: pulumi.String("ENABLED"),
 * 				Type:        pulumi.String("AWS_OWNED_KMS_KEY"),
 * 			},
 * 			LogsAnomalyDetection: &devopsguru.ServiceIntegrationLogsAnomalyDetectionArgs{
 * 				OptInStatus: pulumi.String("ENABLED"),
 * 			},
 * 			OpsCenter: &devopsguru.ServiceIntegrationOpsCenterArgs{
 * 				OptInStatus: pulumi.String("ENABLED"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.devopsguru.ServiceIntegration;
 * import com.pulumi.aws.devopsguru.ServiceIntegrationArgs;
 * import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationKmsServerSideEncryptionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationLogsAnomalyDetectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationOpsCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ServiceIntegration("example", ServiceIntegrationArgs.builder()
 *             .kmsServerSideEncryption(ServiceIntegrationKmsServerSideEncryptionArgs.builder()
 *                 .optInStatus("ENABLED")
 *                 .type("AWS_OWNED_KMS_KEY")
 *                 .build())
 *             .logsAnomalyDetection(ServiceIntegrationLogsAnomalyDetectionArgs.builder()
 *                 .optInStatus("ENABLED")
 *                 .build())
 *             .opsCenter(ServiceIntegrationOpsCenterArgs.builder()
 *                 .optInStatus("ENABLED")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:devopsguru:ServiceIntegration
 *     properties:
 *       kmsServerSideEncryption:
 *         optInStatus: ENABLED
 *         type: AWS_OWNED_KMS_KEY
 *       logsAnomalyDetection:
 *         optInStatus: ENABLED
 *       opsCenter:
 *         optInStatus: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Customer Managed KMS Key
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.kms.Key("example", {});
 * const exampleServiceIntegration = new aws.devopsguru.ServiceIntegration("example", {
 *     kmsServerSideEncryption: {
 *         kmsKeyId: test.arn,
 *         optInStatus: "ENABLED",
 *         type: "CUSTOMER_MANAGED_KEY",
 *     },
 *     logsAnomalyDetection: {
 *         optInStatus: "DISABLED",
 *     },
 *     opsCenter: {
 *         optInStatus: "DISABLED",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.kms.Key("example")
 * example_service_integration = aws.devopsguru.ServiceIntegration("example",
 *     kms_server_side_encryption={
 *         "kms_key_id": test["arn"],
 *         "opt_in_status": "ENABLED",
 *         "type": "CUSTOMER_MANAGED_KEY",
 *     },
 *     logs_anomaly_detection={
 *         "opt_in_status": "DISABLED",
 *     },
 *     ops_center={
 *         "opt_in_status": "DISABLED",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Kms.Key("example");
 *     var exampleServiceIntegration = new Aws.DevOpsGuru.ServiceIntegration("example", new()
 *     {
 *         KmsServerSideEncryption = new Aws.DevOpsGuru.Inputs.ServiceIntegrationKmsServerSideEncryptionArgs
 *         {
 *             KmsKeyId = test.Arn,
 *             OptInStatus = "ENABLED",
 *             Type = "CUSTOMER_MANAGED_KEY",
 *         },
 *         LogsAnomalyDetection = new Aws.DevOpsGuru.Inputs.ServiceIntegrationLogsAnomalyDetectionArgs
 *         {
 *             OptInStatus = "DISABLED",
 *         },
 *         OpsCenter = new Aws.DevOpsGuru.Inputs.ServiceIntegrationOpsCenterArgs
 *         {
 *             OptInStatus = "DISABLED",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/devopsguru"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/kms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := kms.NewKey(ctx, "example", nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = devopsguru.NewServiceIntegration(ctx, "example", &devopsguru.ServiceIntegrationArgs{
 * 			KmsServerSideEncryption: &devopsguru.ServiceIntegrationKmsServerSideEncryptionArgs{
 * 				KmsKeyId:    pulumi.Any(test.Arn),
 * 				OptInStatus: pulumi.String("ENABLED"),
 * 				Type:        pulumi.String("CUSTOMER_MANAGED_KEY"),
 * 			},
 * 			LogsAnomalyDetection: &devopsguru.ServiceIntegrationLogsAnomalyDetectionArgs{
 * 				OptInStatus: pulumi.String("DISABLED"),
 * 			},
 * 			OpsCenter: &devopsguru.ServiceIntegrationOpsCenterArgs{
 * 				OptInStatus: pulumi.String("DISABLED"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.kms.Key;
 * import com.pulumi.aws.devopsguru.ServiceIntegration;
 * import com.pulumi.aws.devopsguru.ServiceIntegrationArgs;
 * import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationKmsServerSideEncryptionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationLogsAnomalyDetectionArgs;
 * import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationOpsCenterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Key("example");
 *         var exampleServiceIntegration = new ServiceIntegration("exampleServiceIntegration", ServiceIntegrationArgs.builder()
 *             .kmsServerSideEncryption(ServiceIntegrationKmsServerSideEncryptionArgs.builder()
 *                 .kmsKeyId(test.arn())
 *                 .optInStatus("ENABLED")
 *                 .type("CUSTOMER_MANAGED_KEY")
 *                 .build())
 *             .logsAnomalyDetection(ServiceIntegrationLogsAnomalyDetectionArgs.builder()
 *                 .optInStatus("DISABLED")
 *                 .build())
 *             .opsCenter(ServiceIntegrationOpsCenterArgs.builder()
 *                 .optInStatus("DISABLED")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:kms:Key
 *   exampleServiceIntegration:
 *     type: aws:devopsguru:ServiceIntegration
 *     name: example
 *     properties:
 *       kmsServerSideEncryption:
 *         kmsKeyId: ${test.arn}
 *         optInStatus: ENABLED
 *         type: CUSTOMER_MANAGED_KEY
 *       logsAnomalyDetection:
 *         optInStatus: DISABLED
 *       opsCenter:
 *         optInStatus: DISABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import DevOps Guru Service Integration using the `id`. For example:
 * ```sh
 * $ pulumi import aws:devopsguru/serviceIntegration:ServiceIntegration example us-east-1
 * ```
 */
public class ServiceIntegration internal constructor(
    override val javaResource: com.pulumi.aws.devopsguru.ServiceIntegration,
) : KotlinCustomResource(javaResource, ServiceIntegrationMapper) {
    /**
     * Information about whether DevOps Guru is configured to encrypt server-side data using KMS. See `kms_server_side_encryption` below.
     */
    public val kmsServerSideEncryption: Output<ServiceIntegrationKmsServerSideEncryption>?
        get() = javaResource.kmsServerSideEncryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceIntegrationKmsServerSideEncryptionToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Information about whether DevOps Guru is configured to perform log anomaly detection on Amazon CloudWatch log groups. See `logs_anomaly_detection` below.
     */
    public val logsAnomalyDetection: Output<ServiceIntegrationLogsAnomalyDetection>?
        get() = javaResource.logsAnomalyDetection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceIntegrationLogsAnomalyDetectionToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Information about whether DevOps Guru is configured to create an OpsItem in AWS Systems Manager OpsCenter for each created insight. See `ops_center` below.
     */
    public val opsCenter: Output<ServiceIntegrationOpsCenter>?
        get() = javaResource.opsCenter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    serviceIntegrationOpsCenterToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ServiceIntegrationMapper : ResourceMapper<ServiceIntegration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.devopsguru.ServiceIntegration::class == javaResource::class

    override fun map(javaResource: Resource): ServiceIntegration = ServiceIntegration(
        javaResource as
            com.pulumi.aws.devopsguru.ServiceIntegration,
    )
}

/**
 * @see [ServiceIntegration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceIntegration].
 */
public suspend fun serviceIntegration(
    name: String,
    block: suspend ServiceIntegrationResourceBuilder.() -> Unit,
): ServiceIntegration {
    val builder = ServiceIntegrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceIntegration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceIntegration(name: String): ServiceIntegration {
    val builder = ServiceIntegrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
