@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property status Status of the CodeGuru Profiler integration. Valid values are `ENABLED` and `DISABLED`.
 */
public data class EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs(
    public val status: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs =
        com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs.builder()
            .status(status.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs].
 */
@PulumiTagMarker
public class EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgsBuilder internal constructor() {
    private var status: Output<String>? = null

    /**
     * @param value Status of the CodeGuru Profiler integration. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("ypilnsvrmdbgxshm")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Status of the CodeGuru Profiler integration. Valid values are `ENABLED` and `DISABLED`.
     */
    @JvmName("anhquynqlcwdougs")
    public suspend fun status(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs =
        EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs(
            status = status ?: throw PulumiNullFieldException("status"),
        )
}
