@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property amazonCodeGuruProfilers Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
 */
public data class EventSourcesConfigEventSourceArgs(
    public val amazonCodeGuruProfilers: Output<List<EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceArgs =
        com.pulumi.aws.devopsguru.inputs.EventSourcesConfigEventSourceArgs.builder()
            .amazonCodeGuruProfilers(
                amazonCodeGuruProfilers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EventSourcesConfigEventSourceArgs].
 */
@PulumiTagMarker
public class EventSourcesConfigEventSourceArgsBuilder internal constructor() {
    private var amazonCodeGuruProfilers:
        Output<List<EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs>>? = null

    /**
     * @param value Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
     */
    @JvmName("lftjqjyvhdbxsjwf")
    public suspend fun amazonCodeGuruProfilers(`value`: Output<List<EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs>>) {
        this.amazonCodeGuruProfilers = value
    }

    @JvmName("obqckfwbptdjkwif")
    public suspend fun amazonCodeGuruProfilers(vararg values: Output<EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs>) {
        this.amazonCodeGuruProfilers = Output.all(values.asList())
    }

    /**
     * @param values Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
     */
    @JvmName("cmqvpkfybhdibapu")
    public suspend fun amazonCodeGuruProfilers(values: List<Output<EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs>>) {
        this.amazonCodeGuruProfilers = Output.all(values)
    }

    /**
     * @param value Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
     */
    @JvmName("jksdlrrrnjlrdckr")
    public suspend fun amazonCodeGuruProfilers(`value`: List<EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonCodeGuruProfilers = mapped
    }

    /**
     * @param argument Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
     */
    @JvmName("kspyfftmvrxkhlur")
    public suspend fun amazonCodeGuruProfilers(argument: List<suspend EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.amazonCodeGuruProfilers = mapped
    }

    /**
     * @param argument Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
     */
    @JvmName("jwtnpxhccowaseku")
    public suspend fun amazonCodeGuruProfilers(vararg argument: suspend EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.amazonCodeGuruProfilers = mapped
    }

    /**
     * @param argument Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
     */
    @JvmName("nphcxjvpbvuujket")
    public suspend fun amazonCodeGuruProfilers(argument: suspend EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.amazonCodeGuruProfilers = mapped
    }

    /**
     * @param values Stores whether DevOps Guru is configured to consume recommendations which are generated from AWS CodeGuru Profiler. See `amazon_code_guru_profiler` below.
     */
    @JvmName("bcbawdwagjrmltvj")
    public suspend fun amazonCodeGuruProfilers(vararg values: EventSourcesConfigEventSourceAmazonCodeGuruProfilerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.amazonCodeGuruProfilers = mapped
    }

    internal fun build(): EventSourcesConfigEventSourceArgs = EventSourcesConfigEventSourceArgs(
        amazonCodeGuruProfilers = amazonCodeGuruProfilers,
    )
}
