@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.GetNotificationChannelFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messageTypes Events to receive notifications for.
 * @property severities Severity levels to receive notifications for.
 */
public data class GetNotificationChannelFilter(
    public val messageTypes: List<String>,
    public val severities: List<String>,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.GetNotificationChannelFilter> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.GetNotificationChannelFilter =
        com.pulumi.aws.devopsguru.inputs.GetNotificationChannelFilter.builder()
            .messageTypes(messageTypes.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .severities(severities.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetNotificationChannelFilter].
 */
@PulumiTagMarker
public class GetNotificationChannelFilterBuilder internal constructor() {
    private var messageTypes: List<String>? = null

    private var severities: List<String>? = null

    /**
     * @param value Events to receive notifications for.
     */
    @JvmName("upuacrkorksxfrpf")
    public suspend fun messageTypes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.messageTypes = mapped
    }

    /**
     * @param values Events to receive notifications for.
     */
    @JvmName("mgxqodfnsvlsbukq")
    public suspend fun messageTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.messageTypes = mapped
    }

    /**
     * @param value Severity levels to receive notifications for.
     */
    @JvmName("ygrpclfpvromviqq")
    public suspend fun severities(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.severities = mapped
    }

    /**
     * @param values Severity levels to receive notifications for.
     */
    @JvmName("rhmccxmspyuuydyb")
    public suspend fun severities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.severities = mapped
    }

    internal fun build(): GetNotificationChannelFilter = GetNotificationChannelFilter(
        messageTypes = messageTypes ?: throw PulumiNullFieldException("messageTypes"),
        severities = severities ?: throw PulumiNullFieldException("severities"),
    )
}
