@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.GetNotificationChannelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNotificationChannel.
 * @property filters Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
 * @property id Unique identifier for the notification channel.
 * @property sns SNS noficiation channel configurations. See the `sns` attribute reference below.
 */
public data class GetNotificationChannelPlainArgs(
    public val filters: List<GetNotificationChannelFilter>? = null,
    public val id: String,
    public val sns: List<GetNotificationChannelSn>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.GetNotificationChannelPlainArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.GetNotificationChannelPlainArgs =
        com.pulumi.aws.devopsguru.inputs.GetNotificationChannelPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id.let({ args0 -> args0 }))
            .sns(sns?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) })).build()
}

/**
 * Builder for [GetNotificationChannelPlainArgs].
 */
@PulumiTagMarker
public class GetNotificationChannelPlainArgsBuilder internal constructor() {
    private var filters: List<GetNotificationChannelFilter>? = null

    private var id: String? = null

    private var sns: List<GetNotificationChannelSn>? = null

    /**
     * @param value Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
     */
    @JvmName("vcjtedekiivlqqkg")
    public suspend fun filters(`value`: List<GetNotificationChannelFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
     */
    @JvmName("hkrhoenjxgioacci")
    public suspend fun filters(argument: List<suspend GetNotificationChannelFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNotificationChannelFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
     */
    @JvmName("wymvafhrsfagypym")
    public suspend fun filters(vararg argument: suspend GetNotificationChannelFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNotificationChannelFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
     */
    @JvmName("cghlsmpdrehfhjsd")
    public suspend fun filters(argument: suspend GetNotificationChannelFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetNotificationChannelFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
     */
    @JvmName("wpgyyymhwdplexca")
    public suspend fun filters(vararg values: GetNotificationChannelFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Unique identifier for the notification channel.
     */
    @JvmName("ytsvwwrgcrhfylwr")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value SNS noficiation channel configurations. See the `sns` attribute reference below.
     */
    @JvmName("fvtrcxfpqllvhqcp")
    public suspend fun sns(`value`: List<GetNotificationChannelSn>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sns = mapped
    }

    /**
     * @param argument SNS noficiation channel configurations. See the `sns` attribute reference below.
     */
    @JvmName("fhqtdmcwhahnmntj")
    public suspend fun sns(argument: List<suspend GetNotificationChannelSnBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetNotificationChannelSnBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.sns = mapped
    }

    /**
     * @param argument SNS noficiation channel configurations. See the `sns` attribute reference below.
     */
    @JvmName("xnekgdxrigheckpd")
    public suspend fun sns(vararg argument: suspend GetNotificationChannelSnBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetNotificationChannelSnBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.sns = mapped
    }

    /**
     * @param argument SNS noficiation channel configurations. See the `sns` attribute reference below.
     */
    @JvmName("neolgsgrpawuxxpk")
    public suspend fun sns(argument: suspend GetNotificationChannelSnBuilder.() -> Unit) {
        val toBeMapped = listOf(GetNotificationChannelSnBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.sns = mapped
    }

    /**
     * @param values SNS noficiation channel configurations. See the `sns` attribute reference below.
     */
    @JvmName("uovociycigsqpywv")
    public suspend fun sns(vararg values: GetNotificationChannelSn) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sns = mapped
    }

    internal fun build(): GetNotificationChannelPlainArgs = GetNotificationChannelPlainArgs(
        filters = filters,
        id = id ?: throw PulumiNullFieldException("id"),
        sns = sns,
    )
}
