@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.GetNotificationChannelSn.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property topicArn Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
 */
public data class GetNotificationChannelSn(
    public val topicArn: String,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.GetNotificationChannelSn> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.GetNotificationChannelSn =
        com.pulumi.aws.devopsguru.inputs.GetNotificationChannelSn.builder()
            .topicArn(topicArn.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNotificationChannelSn].
 */
@PulumiTagMarker
public class GetNotificationChannelSnBuilder internal constructor() {
    private var topicArn: String? = null

    /**
     * @param value Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
     */
    @JvmName("ijrkkkvsecsyiymx")
    public suspend fun topicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.topicArn = mapped
    }

    internal fun build(): GetNotificationChannelSn = GetNotificationChannelSn(
        topicArn = topicArn ?: throw PulumiNullFieldException("topicArn"),
    )
}
