@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.GetResourceCollectionCloudformation.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property stackNames Array of the names of the AWS CloudFormation stacks.
 */
public data class GetResourceCollectionCloudformation(
    public val stackNames: List<String>,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.GetResourceCollectionCloudformation> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.GetResourceCollectionCloudformation =
        com.pulumi.aws.devopsguru.inputs.GetResourceCollectionCloudformation.builder()
            .stackNames(stackNames.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetResourceCollectionCloudformation].
 */
@PulumiTagMarker
public class GetResourceCollectionCloudformationBuilder internal constructor() {
    private var stackNames: List<String>? = null

    /**
     * @param value Array of the names of the AWS CloudFormation stacks.
     */
    @JvmName("itnvameddwoxrhnr")
    public suspend fun stackNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stackNames = mapped
    }

    /**
     * @param values Array of the names of the AWS CloudFormation stacks.
     */
    @JvmName("esoncvemuleojdek")
    public suspend fun stackNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stackNames = mapped
    }

    internal fun build(): GetResourceCollectionCloudformation = GetResourceCollectionCloudformation(
        stackNames = stackNames ?: throw PulumiNullFieldException("stackNames"),
    )
}
