@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.GetResourceCollectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResourceCollection.
 * @property cloudformations A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
 * @property tags AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
 * @property type Type of AWS resource collection to create. Valid values are `AWS_CLOUD_FORMATION`, `AWS_SERVICE`, and `AWS_TAGS`.
 */
public data class GetResourceCollectionPlainArgs(
    public val cloudformations: List<GetResourceCollectionCloudformation>? = null,
    public val tags: List<GetResourceCollectionTag>? = null,
    public val type: String,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.GetResourceCollectionPlainArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.GetResourceCollectionPlainArgs =
        com.pulumi.aws.devopsguru.inputs.GetResourceCollectionPlainArgs.builder()
            .cloudformations(
                cloudformations?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResourceCollectionPlainArgs].
 */
@PulumiTagMarker
public class GetResourceCollectionPlainArgsBuilder internal constructor() {
    private var cloudformations: List<GetResourceCollectionCloudformation>? = null

    private var tags: List<GetResourceCollectionTag>? = null

    private var type: String? = null

    /**
     * @param value A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("uqixbvovlvnunljl")
    public suspend fun cloudformations(`value`: List<GetResourceCollectionCloudformation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.cloudformations = mapped
    }

    /**
     * @param argument A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("yedevyqdeljnipvo")
    public suspend fun cloudformations(argument: List<suspend GetResourceCollectionCloudformationBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetResourceCollectionCloudformationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.cloudformations = mapped
    }

    /**
     * @param argument A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("vykdruhgitgloawl")
    public suspend fun cloudformations(vararg argument: suspend GetResourceCollectionCloudformationBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetResourceCollectionCloudformationBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.cloudformations = mapped
    }

    /**
     * @param argument A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("njpeviddvtdmampy")
    public suspend fun cloudformations(argument: suspend GetResourceCollectionCloudformationBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetResourceCollectionCloudformationBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.cloudformations = mapped
    }

    /**
     * @param values A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
     */
    @JvmName("ulhwypmvufwdrwlb")
    public suspend fun cloudformations(vararg values: GetResourceCollectionCloudformation) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.cloudformations = mapped
    }

    /**
     * @param value AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("gattbtfrxjtmtudn")
    public suspend fun tags(`value`: List<GetResourceCollectionTag>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param argument AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("pxopegepfvvlkufk")
    public suspend fun tags(argument: List<suspend GetResourceCollectionTagBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetResourceCollectionTagBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.tags = mapped
    }

    /**
     * @param argument AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("pxgkxespcplhrjot")
    public suspend fun tags(vararg argument: suspend GetResourceCollectionTagBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetResourceCollectionTagBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.tags = mapped
    }

    /**
     * @param argument AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("ogbpibauyjwbsccx")
    public suspend fun tags(argument: suspend GetResourceCollectionTagBuilder.() -> Unit) {
        val toBeMapped = listOf(GetResourceCollectionTagBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.tags = mapped
    }

    /**
     * @param values AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
     */
    @JvmName("hptghvgnuvotwyeq")
    public suspend fun tags(vararg values: GetResourceCollectionTag) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Type of AWS resource collection to create. Valid values are `AWS_CLOUD_FORMATION`, `AWS_SERVICE`, and `AWS_TAGS`.
     */
    @JvmName("ceisiqxtbctgjhhu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetResourceCollectionPlainArgs = GetResourceCollectionPlainArgs(
        cloudformations = cloudformations,
        tags = tags,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
