@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.GetResourceCollectionTag.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property appBoundaryKey An AWS tag key that is used to identify the AWS resources that DevOps Guru analyzes.
 * @property tagValues Array of tag values.
 */
public data class GetResourceCollectionTag(
    public val appBoundaryKey: String,
    public val tagValues: List<String>,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.GetResourceCollectionTag> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.GetResourceCollectionTag =
        com.pulumi.aws.devopsguru.inputs.GetResourceCollectionTag.builder()
            .appBoundaryKey(appBoundaryKey.let({ args0 -> args0 }))
            .tagValues(tagValues.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetResourceCollectionTag].
 */
@PulumiTagMarker
public class GetResourceCollectionTagBuilder internal constructor() {
    private var appBoundaryKey: String? = null

    private var tagValues: List<String>? = null

    /**
     * @param value An AWS tag key that is used to identify the AWS resources that DevOps Guru analyzes.
     */
    @JvmName("tvyqetuokhvxjofd")
    public suspend fun appBoundaryKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.appBoundaryKey = mapped
    }

    /**
     * @param value Array of tag values.
     */
    @JvmName("ualurunlmqviltyl")
    public suspend fun tagValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagValues = mapped
    }

    /**
     * @param values Array of tag values.
     */
    @JvmName("pitgdfpalvcrlois")
    public suspend fun tagValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tagValues = mapped
    }

    internal fun build(): GetResourceCollectionTag = GetResourceCollectionTag(
        appBoundaryKey = appBoundaryKey ?: throw PulumiNullFieldException("appBoundaryKey"),
        tagValues = tagValues ?: throw PulumiNullFieldException("tagValues"),
    )
}
