@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.NotificationChannelFiltersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property messageTypes Events to receive notifications for. Valid values are `NEW_INSIGHT`, `CLOSED_INSIGHT`, `NEW_ASSOCIATION`, `SEVERITY_UPGRADED`, and `NEW_RECOMMENDATION`.
 * @property severities Severity levels to receive notifications for. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
 */
public data class NotificationChannelFiltersArgs(
    public val messageTypes: Output<List<String>>? = null,
    public val severities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.NotificationChannelFiltersArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.NotificationChannelFiltersArgs =
        com.pulumi.aws.devopsguru.inputs.NotificationChannelFiltersArgs.builder()
            .messageTypes(messageTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .severities(severities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NotificationChannelFiltersArgs].
 */
@PulumiTagMarker
public class NotificationChannelFiltersArgsBuilder internal constructor() {
    private var messageTypes: Output<List<String>>? = null

    private var severities: Output<List<String>>? = null

    /**
     * @param value Events to receive notifications for. Valid values are `NEW_INSIGHT`, `CLOSED_INSIGHT`, `NEW_ASSOCIATION`, `SEVERITY_UPGRADED`, and `NEW_RECOMMENDATION`.
     */
    @JvmName("ybaxymvnrviyiwce")
    public suspend fun messageTypes(`value`: Output<List<String>>) {
        this.messageTypes = value
    }

    @JvmName("lyliunjbykbwmgra")
    public suspend fun messageTypes(vararg values: Output<String>) {
        this.messageTypes = Output.all(values.asList())
    }

    /**
     * @param values Events to receive notifications for. Valid values are `NEW_INSIGHT`, `CLOSED_INSIGHT`, `NEW_ASSOCIATION`, `SEVERITY_UPGRADED`, and `NEW_RECOMMENDATION`.
     */
    @JvmName("dvvseysvfbrpnnsk")
    public suspend fun messageTypes(values: List<Output<String>>) {
        this.messageTypes = Output.all(values)
    }

    /**
     * @param value Severity levels to receive notifications for. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
     */
    @JvmName("mhxrrjtanlofycdj")
    public suspend fun severities(`value`: Output<List<String>>) {
        this.severities = value
    }

    @JvmName("vwdxeobnshjpwdct")
    public suspend fun severities(vararg values: Output<String>) {
        this.severities = Output.all(values.asList())
    }

    /**
     * @param values Severity levels to receive notifications for. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
     */
    @JvmName("gaukwhwaplavpkkx")
    public suspend fun severities(values: List<Output<String>>) {
        this.severities = Output.all(values)
    }

    /**
     * @param value Events to receive notifications for. Valid values are `NEW_INSIGHT`, `CLOSED_INSIGHT`, `NEW_ASSOCIATION`, `SEVERITY_UPGRADED`, and `NEW_RECOMMENDATION`.
     */
    @JvmName("kqoieodluxfbrjhq")
    public suspend fun messageTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageTypes = mapped
    }

    /**
     * @param values Events to receive notifications for. Valid values are `NEW_INSIGHT`, `CLOSED_INSIGHT`, `NEW_ASSOCIATION`, `SEVERITY_UPGRADED`, and `NEW_RECOMMENDATION`.
     */
    @JvmName("nehyygsjsvgngnpn")
    public suspend fun messageTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.messageTypes = mapped
    }

    /**
     * @param value Severity levels to receive notifications for. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
     */
    @JvmName("usrgokfbwxbgtbsq")
    public suspend fun severities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.severities = mapped
    }

    /**
     * @param values Severity levels to receive notifications for. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
     */
    @JvmName("pvbdtbafxwbnyrcv")
    public suspend fun severities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.severities = mapped
    }

    internal fun build(): NotificationChannelFiltersArgs = NotificationChannelFiltersArgs(
        messageTypes = messageTypes,
        severities = severities,
    )
}
