@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property topicArn Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
 */
public data class NotificationChannelSnsArgs(
    public val topicArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs =
        com.pulumi.aws.devopsguru.inputs.NotificationChannelSnsArgs.builder()
            .topicArn(topicArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NotificationChannelSnsArgs].
 */
@PulumiTagMarker
public class NotificationChannelSnsArgsBuilder internal constructor() {
    private var topicArn: Output<String>? = null

    /**
     * @param value Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
     */
    @JvmName("rqrfoenwefhbbwwv")
    public suspend fun topicArn(`value`: Output<String>) {
        this.topicArn = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of an Amazon Simple Notification Service topic.
     */
    @JvmName("iipfompkffkhsrpd")
    public suspend fun topicArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.topicArn = mapped
    }

    internal fun build(): NotificationChannelSnsArgs = NotificationChannelSnsArgs(
        topicArn = topicArn ?: throw PulumiNullFieldException("topicArn"),
    )
}
