@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property stackNames Array of the names of the AWS CloudFormation stacks. If `type` is `AWS_SERVICE` (all acccount resources) this array should be a single item containing a wildcard (`"*"`).
 */
public data class ResourceCollectionCloudformationArgs(
    public val stackNames: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs =
        com.pulumi.aws.devopsguru.inputs.ResourceCollectionCloudformationArgs.builder()
            .stackNames(stackNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResourceCollectionCloudformationArgs].
 */
@PulumiTagMarker
public class ResourceCollectionCloudformationArgsBuilder internal constructor() {
    private var stackNames: Output<List<String>>? = null

    /**
     * @param value Array of the names of the AWS CloudFormation stacks. If `type` is `AWS_SERVICE` (all acccount resources) this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("xjfoyqvgraerfsni")
    public suspend fun stackNames(`value`: Output<List<String>>) {
        this.stackNames = value
    }

    @JvmName("ipbpbwpfixtlurno")
    public suspend fun stackNames(vararg values: Output<String>) {
        this.stackNames = Output.all(values.asList())
    }

    /**
     * @param values Array of the names of the AWS CloudFormation stacks. If `type` is `AWS_SERVICE` (all acccount resources) this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("ufxouyiqhymahjxw")
    public suspend fun stackNames(values: List<Output<String>>) {
        this.stackNames = Output.all(values)
    }

    /**
     * @param value Array of the names of the AWS CloudFormation stacks. If `type` is `AWS_SERVICE` (all acccount resources) this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("xynqjvhhieaoudvj")
    public suspend fun stackNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stackNames = mapped
    }

    /**
     * @param values Array of the names of the AWS CloudFormation stacks. If `type` is `AWS_SERVICE` (all acccount resources) this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("xyiwmfojaufxxgrx")
    public suspend fun stackNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stackNames = mapped
    }

    internal fun build(): ResourceCollectionCloudformationArgs = ResourceCollectionCloudformationArgs(
        stackNames = stackNames ?: throw PulumiNullFieldException("stackNames"),
    )
}
