@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property appBoundaryKey An AWS tag key that is used to identify the AWS resources that DevOps Guru analyzes. All AWS resources in your account and Region tagged with this key make up your DevOps Guru application and analysis boundary. The key must begin with the prefix `DevOps-Guru-`. Any casing can be used for the prefix, but the associated tags __must use the same casing__ in their tag key.
 * @property tagValues Array of tag values. These can be used to further filter for specific resources within the application boundary. To analyze all resources tagged with the `app_boundary_key` regardless of the corresponding tag value, this array should be a single item containing a wildcard (`"*"`).
 */
public data class ResourceCollectionTagsArgs(
    public val appBoundaryKey: Output<String>,
    public val tagValues: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs =
        com.pulumi.aws.devopsguru.inputs.ResourceCollectionTagsArgs.builder()
            .appBoundaryKey(appBoundaryKey.applyValue({ args0 -> args0 }))
            .tagValues(tagValues.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ResourceCollectionTagsArgs].
 */
@PulumiTagMarker
public class ResourceCollectionTagsArgsBuilder internal constructor() {
    private var appBoundaryKey: Output<String>? = null

    private var tagValues: Output<List<String>>? = null

    /**
     * @param value An AWS tag key that is used to identify the AWS resources that DevOps Guru analyzes. All AWS resources in your account and Region tagged with this key make up your DevOps Guru application and analysis boundary. The key must begin with the prefix `DevOps-Guru-`. Any casing can be used for the prefix, but the associated tags __must use the same casing__ in their tag key.
     */
    @JvmName("ctfuxcmrkpvaddjt")
    public suspend fun appBoundaryKey(`value`: Output<String>) {
        this.appBoundaryKey = value
    }

    /**
     * @param value Array of tag values. These can be used to further filter for specific resources within the application boundary. To analyze all resources tagged with the `app_boundary_key` regardless of the corresponding tag value, this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("vwvtxhfwlsdhwwvl")
    public suspend fun tagValues(`value`: Output<List<String>>) {
        this.tagValues = value
    }

    @JvmName("xnkykwwbftmtkmih")
    public suspend fun tagValues(vararg values: Output<String>) {
        this.tagValues = Output.all(values.asList())
    }

    /**
     * @param values Array of tag values. These can be used to further filter for specific resources within the application boundary. To analyze all resources tagged with the `app_boundary_key` regardless of the corresponding tag value, this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("wgdqgcnjjchepkxi")
    public suspend fun tagValues(values: List<Output<String>>) {
        this.tagValues = Output.all(values)
    }

    /**
     * @param value An AWS tag key that is used to identify the AWS resources that DevOps Guru analyzes. All AWS resources in your account and Region tagged with this key make up your DevOps Guru application and analysis boundary. The key must begin with the prefix `DevOps-Guru-`. Any casing can be used for the prefix, but the associated tags __must use the same casing__ in their tag key.
     */
    @JvmName("urbllixhgcfsyavi")
    public suspend fun appBoundaryKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appBoundaryKey = mapped
    }

    /**
     * @param value Array of tag values. These can be used to further filter for specific resources within the application boundary. To analyze all resources tagged with the `app_boundary_key` regardless of the corresponding tag value, this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("cnulhqkxlocwqqve")
    public suspend fun tagValues(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    /**
     * @param values Array of tag values. These can be used to further filter for specific resources within the application boundary. To analyze all resources tagged with the `app_boundary_key` regardless of the corresponding tag value, this array should be a single item containing a wildcard (`"*"`).
     */
    @JvmName("hmsgpaovjxsfiihv")
    public suspend fun tagValues(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagValues = mapped
    }

    internal fun build(): ResourceCollectionTagsArgs = ResourceCollectionTagsArgs(
        appBoundaryKey = appBoundaryKey ?: throw PulumiNullFieldException("appBoundaryKey"),
        tagValues = tagValues ?: throw PulumiNullFieldException("tagValues"),
    )
}
