@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationKmsServerSideEncryptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property kmsKeyId KMS key ID. This value can be a key ID, key ARN, alias name, or alias ARN.
 * @property optInStatus Specifies whether KMS integration is enabled. Valid values are `DISABLED` and `ENABLED`.
 * @property type Type of KMS key used. Valid values are `CUSTOMER_MANAGED_KEY` and `AWS_OWNED_KMS_KEY`.
 */
public data class ServiceIntegrationKmsServerSideEncryptionArgs(
    public val kmsKeyId: Output<String>? = null,
    public val optInStatus: Output<String>? = null,
    public val type: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.ServiceIntegrationKmsServerSideEncryptionArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.ServiceIntegrationKmsServerSideEncryptionArgs =
        com.pulumi.aws.devopsguru.inputs.ServiceIntegrationKmsServerSideEncryptionArgs.builder()
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .optInStatus(optInStatus?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceIntegrationKmsServerSideEncryptionArgs].
 */
@PulumiTagMarker
public class ServiceIntegrationKmsServerSideEncryptionArgsBuilder internal constructor() {
    private var kmsKeyId: Output<String>? = null

    private var optInStatus: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value KMS key ID. This value can be a key ID, key ARN, alias name, or alias ARN.
     */
    @JvmName("oglvhpkhwufmtcrq")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value Specifies whether KMS integration is enabled. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("qxwpaktafmkqjjyn")
    public suspend fun optInStatus(`value`: Output<String>) {
        this.optInStatus = value
    }

    /**
     * @param value Type of KMS key used. Valid values are `CUSTOMER_MANAGED_KEY` and `AWS_OWNED_KMS_KEY`.
     */
    @JvmName("vdwovmhcyiuoboby")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value KMS key ID. This value can be a key ID, key ARN, alias name, or alias ARN.
     */
    @JvmName("fjevynfocenothmp")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value Specifies whether KMS integration is enabled. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("rvbvnphjxdpprkfe")
    public suspend fun optInStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optInStatus = mapped
    }

    /**
     * @param value Type of KMS key used. Valid values are `CUSTOMER_MANAGED_KEY` and `AWS_OWNED_KMS_KEY`.
     */
    @JvmName("downungdfwujpcos")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceIntegrationKmsServerSideEncryptionArgs =
        ServiceIntegrationKmsServerSideEncryptionArgs(
            kmsKeyId = kmsKeyId,
            optInStatus = optInStatus,
            type = type,
        )
}
