@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationLogsAnomalyDetectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property optInStatus Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups. Valid values are `DISABLED` and `ENABLED`.
 */
public data class ServiceIntegrationLogsAnomalyDetectionArgs(
    public val optInStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.ServiceIntegrationLogsAnomalyDetectionArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.ServiceIntegrationLogsAnomalyDetectionArgs = com.pulumi.aws.devopsguru.inputs.ServiceIntegrationLogsAnomalyDetectionArgs.builder()
        .optInStatus(optInStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceIntegrationLogsAnomalyDetectionArgs].
 */
@PulumiTagMarker
public class ServiceIntegrationLogsAnomalyDetectionArgsBuilder internal constructor() {
    private var optInStatus: Output<String>? = null

    /**
     * @param value Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("ygdkyncskdgxsvmn")
    public suspend fun optInStatus(`value`: Output<String>) {
        this.optInStatus = value
    }

    /**
     * @param value Specifies if DevOps Guru is configured to perform log anomaly detection on CloudWatch log groups. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("iswdqvvviuocpute")
    public suspend fun optInStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optInStatus = mapped
    }

    internal fun build(): ServiceIntegrationLogsAnomalyDetectionArgs =
        ServiceIntegrationLogsAnomalyDetectionArgs(
            optInStatus = optInStatus,
        )
}
