@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.inputs

import com.pulumi.aws.devopsguru.inputs.ServiceIntegrationOpsCenterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property optInStatus Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight. Valid values are `DISABLED` and `ENABLED`.
 */
public data class ServiceIntegrationOpsCenterArgs(
    public val optInStatus: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.devopsguru.inputs.ServiceIntegrationOpsCenterArgs> {
    override fun toJava(): com.pulumi.aws.devopsguru.inputs.ServiceIntegrationOpsCenterArgs =
        com.pulumi.aws.devopsguru.inputs.ServiceIntegrationOpsCenterArgs.builder()
            .optInStatus(optInStatus?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceIntegrationOpsCenterArgs].
 */
@PulumiTagMarker
public class ServiceIntegrationOpsCenterArgsBuilder internal constructor() {
    private var optInStatus: Output<String>? = null

    /**
     * @param value Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("jnjtfuyamyuwrmll")
    public suspend fun optInStatus(`value`: Output<String>) {
        this.optInStatus = value
    }

    /**
     * @param value Specifies if DevOps Guru is enabled to create an AWS Systems Manager OpsItem for each created insight. Valid values are `DISABLED` and `ENABLED`.
     */
    @JvmName("ddbtxykfgbcgvlfi")
    public suspend fun optInStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.optInStatus = mapped
    }

    internal fun build(): ServiceIntegrationOpsCenterArgs = ServiceIntegrationOpsCenterArgs(
        optInStatus = optInStatus,
    )
}
