@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property messageTypes Events to receive notifications for.
 * @property severities Severity levels to receive notifications for.
 */
public data class GetNotificationChannelFilter(
    public val messageTypes: List<String>,
    public val severities: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devopsguru.outputs.GetNotificationChannelFilter): GetNotificationChannelFilter = GetNotificationChannelFilter(
            messageTypes = javaType.messageTypes().map({ args0 -> args0 }),
            severities = javaType.severities().map({ args0 -> args0 }),
        )
    }
}
