@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNotificationChannel.
 * @property filters Filter configurations for the Amazon SNS notification topic. See the `filters` attribute reference below.
 * @property id
 * @property sns SNS noficiation channel configurations. See the `sns` attribute reference below.
 */
public data class GetNotificationChannelResult(
    public val filters: List<GetNotificationChannelFilter>? = null,
    public val id: String,
    public val sns: List<GetNotificationChannelSn>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devopsguru.outputs.GetNotificationChannelResult): GetNotificationChannelResult = GetNotificationChannelResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.devopsguru.kotlin.outputs.GetNotificationChannelFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            sns = javaType.sns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.devopsguru.kotlin.outputs.GetNotificationChannelSn.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
