@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResourceCollection.
 * @property cloudformations A collection of AWS CloudFormation stacks. See `cloudformation` below for additional details.
 * @property id Type of AWS resource collection to create (same value as `type`).
 * @property tags AWS tags used to filter the resources in the resource collection. See `tags` below for additional details.
 * @property type
 */
public data class GetResourceCollectionResult(
    public val cloudformations: List<GetResourceCollectionCloudformation>? = null,
    public val id: String,
    public val tags: List<GetResourceCollectionTag>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devopsguru.outputs.GetResourceCollectionResult): GetResourceCollectionResult = GetResourceCollectionResult(
            cloudformations = javaType.cloudformations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.devopsguru.kotlin.outputs.GetResourceCollectionCloudformation.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            tags = javaType.tags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.devopsguru.kotlin.outputs.GetResourceCollectionTag.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
