@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property appBoundaryKey An AWS tag key that is used to identify the AWS resources that DevOps Guru analyzes.
 * @property tagValues Array of tag values.
 */
public data class GetResourceCollectionTag(
    public val appBoundaryKey: String,
    public val tagValues: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devopsguru.outputs.GetResourceCollectionTag): GetResourceCollectionTag = GetResourceCollectionTag(
            appBoundaryKey = javaType.appBoundaryKey(),
            tagValues = javaType.tagValues().map({ args0 -> args0 }),
        )
    }
}
