@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property messageTypes Events to receive notifications for. Valid values are `NEW_INSIGHT`, `CLOSED_INSIGHT`, `NEW_ASSOCIATION`, `SEVERITY_UPGRADED`, and `NEW_RECOMMENDATION`.
 * @property severities Severity levels to receive notifications for. Valid values are `LOW`, `MEDIUM`, and `HIGH`.
 */
public data class NotificationChannelFilters(
    public val messageTypes: List<String>? = null,
    public val severities: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devopsguru.outputs.NotificationChannelFilters): NotificationChannelFilters = NotificationChannelFilters(
            messageTypes = javaType.messageTypes().map({ args0 -> args0 }),
            severities = javaType.severities().map({ args0 -> args0 }),
        )
    }
}
