@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property stackNames Array of the names of the AWS CloudFormation stacks. If `type` is `AWS_SERVICE` (all acccount resources) this array should be a single item containing a wildcard (`"*"`).
 */
public data class ResourceCollectionCloudformation(
    public val stackNames: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devopsguru.outputs.ResourceCollectionCloudformation): ResourceCollectionCloudformation = ResourceCollectionCloudformation(
            stackNames = javaType.stackNames().map({ args0 -> args0 }),
        )
    }
}
