@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.devopsguru.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property kmsKeyId KMS key ID. This value can be a key ID, key ARN, alias name, or alias ARN.
 * @property optInStatus Specifies whether KMS integration is enabled. Valid values are `DISABLED` and `ENABLED`.
 * @property type Type of KMS key used. Valid values are `CUSTOMER_MANAGED_KEY` and `AWS_OWNED_KMS_KEY`.
 */
public data class ServiceIntegrationKmsServerSideEncryption(
    public val kmsKeyId: String? = null,
    public val optInStatus: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.devopsguru.outputs.ServiceIntegrationKmsServerSideEncryption): ServiceIntegrationKmsServerSideEncryption = ServiceIntegrationKmsServerSideEncryption(
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            optInStatus = javaType.optInStatus().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
