@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.ConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a Connection of Direct Connect.
 * ## Example Usage
 * ### Create a connection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const hoge = new aws.directconnect.Connection("hoge", {
 *     name: "tf-dx-connection",
 *     bandwidth: "1Gbps",
 *     location: "EqDC2",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * hoge = aws.directconnect.Connection("hoge",
 *     name="tf-dx-connection",
 *     bandwidth="1Gbps",
 *     location="EqDC2")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var hoge = new Aws.DirectConnect.Connection("hoge", new()
 *     {
 *         Name = "tf-dx-connection",
 *         Bandwidth = "1Gbps",
 *         Location = "EqDC2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewConnection(ctx, "hoge", &directconnect.ConnectionArgs{
 * 			Name:      pulumi.String("tf-dx-connection"),
 * 			Bandwidth: pulumi.String("1Gbps"),
 * 			Location:  pulumi.String("EqDC2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Connection;
 * import com.pulumi.aws.directconnect.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var hoge = new Connection("hoge", ConnectionArgs.builder()
 *             .name("tf-dx-connection")
 *             .bandwidth("1Gbps")
 *             .location("EqDC2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   hoge:
 *     type: aws:directconnect:Connection
 *     properties:
 *       name: tf-dx-connection
 *       bandwidth: 1Gbps
 *       location: EqDC2
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Request a MACsec-capable connection
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.Connection("example", {
 *     name: "tf-dx-connection",
 *     bandwidth: "10Gbps",
 *     location: "EqDA2",
 *     requestMacsec: true,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.Connection("example",
 *     name="tf-dx-connection",
 *     bandwidth="10Gbps",
 *     location="EqDA2",
 *     request_macsec=True)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.Connection("example", new()
 *     {
 *         Name = "tf-dx-connection",
 *         Bandwidth = "10Gbps",
 *         Location = "EqDA2",
 *         RequestMacsec = true,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewConnection(ctx, "example", &directconnect.ConnectionArgs{
 * 			Name:          pulumi.String("tf-dx-connection"),
 * 			Bandwidth:     pulumi.String("10Gbps"),
 * 			Location:      pulumi.String("EqDA2"),
 * 			RequestMacsec: pulumi.Bool(true),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Connection;
 * import com.pulumi.aws.directconnect.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .name("tf-dx-connection")
 *             .bandwidth("10Gbps")
 *             .location("EqDA2")
 *             .requestMacsec(true)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:Connection
 *     properties:
 *       name: tf-dx-connection
 *       bandwidth: 10Gbps
 *       location: EqDA2
 *       requestMacsec: true
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Configure encryption mode for MACsec-capable connections
 * > **NOTE:** You can only specify the `encryption_mode` argument once the connection is in an `Available` state.
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.Connection("example", {
 *     name: "tf-dx-connection",
 *     bandwidth: "10Gbps",
 *     location: "EqDC2",
 *     requestMacsec: true,
 *     encryptionMode: "must_encrypt",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.Connection("example",
 *     name="tf-dx-connection",
 *     bandwidth="10Gbps",
 *     location="EqDC2",
 *     request_macsec=True,
 *     encryption_mode="must_encrypt")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.Connection("example", new()
 *     {
 *         Name = "tf-dx-connection",
 *         Bandwidth = "10Gbps",
 *         Location = "EqDC2",
 *         RequestMacsec = true,
 *         EncryptionMode = "must_encrypt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewConnection(ctx, "example", &directconnect.ConnectionArgs{
 * 			Name:           pulumi.String("tf-dx-connection"),
 * 			Bandwidth:      pulumi.String("10Gbps"),
 * 			Location:       pulumi.String("EqDC2"),
 * 			RequestMacsec:  pulumi.Bool(true),
 * 			EncryptionMode: pulumi.String("must_encrypt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Connection;
 * import com.pulumi.aws.directconnect.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .name("tf-dx-connection")
 *             .bandwidth("10Gbps")
 *             .location("EqDC2")
 *             .requestMacsec(true)
 *             .encryptionMode("must_encrypt")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:Connection
 *     properties:
 *       name: tf-dx-connection
 *       bandwidth: 10Gbps
 *       location: EqDC2
 *       requestMacsec: true
 *       encryptionMode: must_encrypt
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect connections using the connection `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/connection:Connection test_connection dxcon-ffre0ec3
 * ```
 * @property bandwidth The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
 * @property encryptionMode The connection MAC Security (MACsec) encryption mode. MAC Security (MACsec) is only available on dedicated connections. Valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
 * @property location The AWS Direct Connect location where the connection is located. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
 * @property name The name of the connection.
 * @property providerName The name of the service provider associated with the connection.
 * @property requestMacsec Boolean value indicating whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for more information about MAC Security (MACsec) prerequisites. Default value: `false`.
 * > **NOTE:** Changing the value of `request_macsec` will cause the resource to be destroyed and re-created.
 * @property skipDestroy Set to true if you do not wish the connection to be deleted at destroy time, and instead just removed from the state.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectionArgs(
    public val bandwidth: Output<String>? = null,
    public val encryptionMode: Output<String>? = null,
    public val location: Output<String>? = null,
    public val name: Output<String>? = null,
    public val providerName: Output<String>? = null,
    public val requestMacsec: Output<Boolean>? = null,
    public val skipDestroy: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.ConnectionArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.ConnectionArgs =
        com.pulumi.aws.directconnect.ConnectionArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .encryptionMode(encryptionMode?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .requestMacsec(requestMacsec?.applyValue({ args0 -> args0 }))
            .skipDestroy(skipDestroy?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var bandwidth: Output<String>? = null

    private var encryptionMode: Output<String>? = null

    private var location: Output<String>? = null

    private var name: Output<String>? = null

    private var providerName: Output<String>? = null

    private var requestMacsec: Output<Boolean>? = null

    private var skipDestroy: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
     */
    @JvmName("swshkuqhsxgsjhtq")
    public suspend fun bandwidth(`value`: Output<String>) {
        this.bandwidth = value
    }

    /**
     * @param value The connection MAC Security (MACsec) encryption mode. MAC Security (MACsec) is only available on dedicated connections. Valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
     */
    @JvmName("iqvhqagacllfnhbk")
    public suspend fun encryptionMode(`value`: Output<String>) {
        this.encryptionMode = value
    }

    /**
     * @param value The AWS Direct Connect location where the connection is located. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
     */
    @JvmName("lrisekslesgpwifl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("avtfhfkdbseugsdj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the service provider associated with the connection.
     */
    @JvmName("iilqsbkpelbsyxpc")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value Boolean value indicating whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for more information about MAC Security (MACsec) prerequisites. Default value: `false`.
     * > **NOTE:** Changing the value of `request_macsec` will cause the resource to be destroyed and re-created.
     */
    @JvmName("ewecouvdtchopsgl")
    public suspend fun requestMacsec(`value`: Output<Boolean>) {
        this.requestMacsec = value
    }

    /**
     * @param value Set to true if you do not wish the connection to be deleted at destroy time, and instead just removed from the state.
     */
    @JvmName("mlnrduawwrihynfr")
    public suspend fun skipDestroy(`value`: Output<Boolean>) {
        this.skipDestroy = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("koxgdmhtbtckbomq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The bandwidth of the connection. Valid values for dedicated connections: 1Gbps, 10Gbps. Valid values for hosted connections: 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, 10Gbps and 100Gbps. Case sensitive.
     */
    @JvmName("ccjnccmspwjcyhgj")
    public suspend fun bandwidth(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value The connection MAC Security (MACsec) encryption mode. MAC Security (MACsec) is only available on dedicated connections. Valid values are `no_encrypt`, `should_encrypt`, and `must_encrypt`.
     */
    @JvmName("tvdvruioivcvbnvf")
    public suspend fun encryptionMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionMode = mapped
    }

    /**
     * @param value The AWS Direct Connect location where the connection is located. See [DescribeLocations](https://docs.aws.amazon.com/directconnect/latest/APIReference/API_DescribeLocations.html) for the list of AWS Direct Connect locations. Use `locationCode`.
     */
    @JvmName("hcotxlbjiprglbix")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("xfghpygbdynrhhij")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the service provider associated with the connection.
     */
    @JvmName("skdxudfwcmdtogvu")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value Boolean value indicating whether you want the connection to support MAC Security (MACsec). MAC Security (MACsec) is only available on dedicated connections. See [MACsec prerequisites](https://docs.aws.amazon.com/directconnect/latest/UserGuide/direct-connect-mac-sec-getting-started.html#mac-sec-prerequisites) for more information about MAC Security (MACsec) prerequisites. Default value: `false`.
     * > **NOTE:** Changing the value of `request_macsec` will cause the resource to be destroyed and re-created.
     */
    @JvmName("epuefmdygrasvels")
    public suspend fun requestMacsec(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMacsec = mapped
    }

    /**
     * @param value Set to true if you do not wish the connection to be deleted at destroy time, and instead just removed from the state.
     */
    @JvmName("ddvtjaxxxcltujfp")
    public suspend fun skipDestroy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipDestroy = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jtknmjuwcqsysxrb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vffnlkfqaxrbvhip")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        bandwidth = bandwidth,
        encryptionMode = encryptionMode,
        location = location,
        name = name,
        providerName = providerName,
        requestMacsec = requestMacsec,
        skipDestroy = skipDestroy,
        tags = tags,
    )
}
