@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.ConnectionAssociationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Associates a Direct Connect Connection with a LAG.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.Connection("example", {
 *     name: "example",
 *     bandwidth: "1Gbps",
 *     location: "EqSe2-EQ",
 * });
 * const exampleLinkAggregationGroup = new aws.directconnect.LinkAggregationGroup("example", {
 *     name: "example",
 *     connectionsBandwidth: "1Gbps",
 *     location: "EqSe2-EQ",
 * });
 * const exampleConnectionAssociation = new aws.directconnect.ConnectionAssociation("example", {
 *     connectionId: example.id,
 *     lagId: exampleLinkAggregationGroup.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.Connection("example",
 *     name="example",
 *     bandwidth="1Gbps",
 *     location="EqSe2-EQ")
 * example_link_aggregation_group = aws.directconnect.LinkAggregationGroup("example",
 *     name="example",
 *     connections_bandwidth="1Gbps",
 *     location="EqSe2-EQ")
 * example_connection_association = aws.directconnect.ConnectionAssociation("example",
 *     connection_id=example.id,
 *     lag_id=example_link_aggregation_group.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.Connection("example", new()
 *     {
 *         Name = "example",
 *         Bandwidth = "1Gbps",
 *         Location = "EqSe2-EQ",
 *     });
 *     var exampleLinkAggregationGroup = new Aws.DirectConnect.LinkAggregationGroup("example", new()
 *     {
 *         Name = "example",
 *         ConnectionsBandwidth = "1Gbps",
 *         Location = "EqSe2-EQ",
 *     });
 *     var exampleConnectionAssociation = new Aws.DirectConnect.ConnectionAssociation("example", new()
 *     {
 *         ConnectionId = example.Id,
 *         LagId = exampleLinkAggregationGroup.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := directconnect.NewConnection(ctx, "example", &directconnect.ConnectionArgs{
 * 			Name:      pulumi.String("example"),
 * 			Bandwidth: pulumi.String("1Gbps"),
 * 			Location:  pulumi.String("EqSe2-EQ"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleLinkAggregationGroup, err := directconnect.NewLinkAggregationGroup(ctx, "example", &directconnect.LinkAggregationGroupArgs{
 * 			Name:                 pulumi.String("example"),
 * 			ConnectionsBandwidth: pulumi.String("1Gbps"),
 * 			Location:             pulumi.String("EqSe2-EQ"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = directconnect.NewConnectionAssociation(ctx, "example", &directconnect.ConnectionAssociationArgs{
 * 			ConnectionId: example.ID(),
 * 			LagId:        exampleLinkAggregationGroup.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Connection;
 * import com.pulumi.aws.directconnect.ConnectionArgs;
 * import com.pulumi.aws.directconnect.LinkAggregationGroup;
 * import com.pulumi.aws.directconnect.LinkAggregationGroupArgs;
 * import com.pulumi.aws.directconnect.ConnectionAssociation;
 * import com.pulumi.aws.directconnect.ConnectionAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .name("example")
 *             .bandwidth("1Gbps")
 *             .location("EqSe2-EQ")
 *             .build());
 *         var exampleLinkAggregationGroup = new LinkAggregationGroup("exampleLinkAggregationGroup", LinkAggregationGroupArgs.builder()
 *             .name("example")
 *             .connectionsBandwidth("1Gbps")
 *             .location("EqSe2-EQ")
 *             .build());
 *         var exampleConnectionAssociation = new ConnectionAssociation("exampleConnectionAssociation", ConnectionAssociationArgs.builder()
 *             .connectionId(example.id())
 *             .lagId(exampleLinkAggregationGroup.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:Connection
 *     properties:
 *       name: example
 *       bandwidth: 1Gbps
 *       location: EqSe2-EQ
 *   exampleLinkAggregationGroup:
 *     type: aws:directconnect:LinkAggregationGroup
 *     name: example
 *     properties:
 *       name: example
 *       connectionsBandwidth: 1Gbps
 *       location: EqSe2-EQ
 *   exampleConnectionAssociation:
 *     type: aws:directconnect:ConnectionAssociation
 *     name: example
 *     properties:
 *       connectionId: ${example.id}
 *       lagId: ${exampleLinkAggregationGroup.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property connectionId The ID of the connection.
 * @property lagId The ID of the LAG with which to associate the connection.
 */
public data class ConnectionAssociationArgs(
    public val connectionId: Output<String>? = null,
    public val lagId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.ConnectionAssociationArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.ConnectionAssociationArgs =
        com.pulumi.aws.directconnect.ConnectionAssociationArgs.builder()
            .connectionId(connectionId?.applyValue({ args0 -> args0 }))
            .lagId(lagId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionAssociationArgs].
 */
@PulumiTagMarker
public class ConnectionAssociationArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    private var lagId: Output<String>? = null

    /**
     * @param value The ID of the connection.
     */
    @JvmName("yruqddswdinvdwdc")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The ID of the LAG with which to associate the connection.
     */
    @JvmName("lyqrmmotyiujhsyx")
    public suspend fun lagId(`value`: Output<String>) {
        this.lagId = value
    }

    /**
     * @param value The ID of the connection.
     */
    @JvmName("wwxlqptqmkgusduj")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    /**
     * @param value The ID of the LAG with which to associate the connection.
     */
    @JvmName("sawaxxhhrkjgmylx")
    public suspend fun lagId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lagId = mapped
    }

    internal fun build(): ConnectionAssociationArgs = ConnectionAssociationArgs(
        connectionId = connectionId,
        lagId = lagId,
    )
}
