@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ConnectionConfirmation].
 */
@PulumiTagMarker
public class ConnectionConfirmationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ConnectionConfirmationArgs = ConnectionConfirmationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ConnectionConfirmationArgsBuilder.() -> Unit) {
        val builder = ConnectionConfirmationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ConnectionConfirmation {
        val builtJavaResource =
            com.pulumi.aws.directconnect.ConnectionConfirmation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ConnectionConfirmation(builtJavaResource)
    }
}

/**
 * Provides a confirmation of the creation of the specified hosted connection on an interconnect.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const confirmation = new aws.directconnect.ConnectionConfirmation("confirmation", {connectionId: "dxcon-ffabc123"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * confirmation = aws.directconnect.ConnectionConfirmation("confirmation", connection_id="dxcon-ffabc123")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var confirmation = new Aws.DirectConnect.ConnectionConfirmation("confirmation", new()
 *     {
 *         ConnectionId = "dxcon-ffabc123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewConnectionConfirmation(ctx, "confirmation", &directconnect.ConnectionConfirmationArgs{
 * 			ConnectionId: pulumi.String("dxcon-ffabc123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.ConnectionConfirmation;
 * import com.pulumi.aws.directconnect.ConnectionConfirmationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var confirmation = new ConnectionConfirmation("confirmation", ConnectionConfirmationArgs.builder()
 *             .connectionId("dxcon-ffabc123")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   confirmation:
 *     type: aws:directconnect:ConnectionConfirmation
 *     properties:
 *       connectionId: dxcon-ffabc123
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class ConnectionConfirmation internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.ConnectionConfirmation,
) : KotlinCustomResource(javaResource, ConnectionConfirmationMapper) {
    /**
     * The ID of the hosted connection.
     */
    public val connectionId: Output<String>
        get() = javaResource.connectionId().applyValue({ args0 -> args0 })
}

public object ConnectionConfirmationMapper : ResourceMapper<ConnectionConfirmation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.ConnectionConfirmation::class == javaResource::class

    override fun map(javaResource: Resource): ConnectionConfirmation =
        ConnectionConfirmation(javaResource as com.pulumi.aws.directconnect.ConnectionConfirmation)
}

/**
 * @see [ConnectionConfirmation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ConnectionConfirmation].
 */
public suspend fun connectionConfirmation(
    name: String,
    block: suspend ConnectionConfirmationResourceBuilder.() -> Unit,
): ConnectionConfirmation {
    val builder = ConnectionConfirmationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ConnectionConfirmation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun connectionConfirmation(name: String): ConnectionConfirmation {
    val builder = ConnectionConfirmationResourceBuilder()
    builder.name(name)
    return builder.build()
}
