@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.ConnectionConfirmationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a confirmation of the creation of the specified hosted connection on an interconnect.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const confirmation = new aws.directconnect.ConnectionConfirmation("confirmation", {connectionId: "dxcon-ffabc123"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * confirmation = aws.directconnect.ConnectionConfirmation("confirmation", connection_id="dxcon-ffabc123")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var confirmation = new Aws.DirectConnect.ConnectionConfirmation("confirmation", new()
 *     {
 *         ConnectionId = "dxcon-ffabc123",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewConnectionConfirmation(ctx, "confirmation", &directconnect.ConnectionConfirmationArgs{
 * 			ConnectionId: pulumi.String("dxcon-ffabc123"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.ConnectionConfirmation;
 * import com.pulumi.aws.directconnect.ConnectionConfirmationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var confirmation = new ConnectionConfirmation("confirmation", ConnectionConfirmationArgs.builder()
 *             .connectionId("dxcon-ffabc123")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   confirmation:
 *     type: aws:directconnect:ConnectionConfirmation
 *     properties:
 *       connectionId: dxcon-ffabc123
 * ```
 * <!--End PulumiCodeChooser -->
 * @property connectionId The ID of the hosted connection.
 */
public data class ConnectionConfirmationArgs(
    public val connectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.ConnectionConfirmationArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.ConnectionConfirmationArgs =
        com.pulumi.aws.directconnect.ConnectionConfirmationArgs.builder()
            .connectionId(connectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionConfirmationArgs].
 */
@PulumiTagMarker
public class ConnectionConfirmationArgsBuilder internal constructor() {
    private var connectionId: Output<String>? = null

    /**
     * @param value The ID of the hosted connection.
     */
    @JvmName("igvkpjsllpgwetvs")
    public suspend fun connectionId(`value`: Output<String>) {
        this.connectionId = value
    }

    /**
     * @param value The ID of the hosted connection.
     */
    @JvmName("ikitfiokpmcqdupq")
    public suspend fun connectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionId = mapped
    }

    internal fun build(): ConnectionConfirmationArgs = ConnectionConfirmationArgs(
        connectionId = connectionId,
    )
}
