@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource = com.pulumi.aws.directconnect.Gateway(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Gateway(builtJavaResource)
    }
}

/**
 * Provides a Direct Connect Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.Gateway("example", {
 *     name: "tf-dxg-example",
 *     amazonSideAsn: "64512",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.Gateway("example",
 *     name="tf-dxg-example",
 *     amazon_side_asn="64512")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.Gateway("example", new()
 *     {
 *         Name = "tf-dxg-example",
 *         AmazonSideAsn = "64512",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewGateway(ctx, "example", &directconnect.GatewayArgs{
 * 			Name:          pulumi.String("tf-dxg-example"),
 * 			AmazonSideAsn: pulumi.String("64512"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .name("tf-dxg-example")
 *             .amazonSideAsn("64512")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:Gateway
 *     properties:
 *       name: tf-dxg-example
 *       amazonSideAsn: '64512'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect Gateways using the gateway `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/gateway:Gateway test abcd1234-dcba-5678-be23-cdef9876ab45
 * ```
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.aws.directconnect.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * The ASN to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
     */
    public val amazonSideAsn: Output<String>
        get() = javaResource.amazonSideAsn().applyValue({ args0 -> args0 })

    /**
     * The name of the connection.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * AWS Account ID of the gateway.
     */
    public val ownerAccountId: Output<String>
        get() = javaResource.ownerAccountId().applyValue({ args0 -> args0 })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.directconnect.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.aws.directconnect.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
