@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.directconnect.kotlin

import com.pulumi.aws.directconnect.GatewayArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a Direct Connect Gateway.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.directconnect.Gateway("example", {
 *     name: "tf-dxg-example",
 *     amazonSideAsn: "64512",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.directconnect.Gateway("example",
 *     name="tf-dxg-example",
 *     amazon_side_asn="64512")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.DirectConnect.Gateway("example", new()
 *     {
 *         Name = "tf-dxg-example",
 *         AmazonSideAsn = "64512",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/directconnect"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := directconnect.NewGateway(ctx, "example", &directconnect.GatewayArgs{
 * 			Name:          pulumi.String("tf-dxg-example"),
 * 			AmazonSideAsn: pulumi.String("64512"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.directconnect.Gateway;
 * import com.pulumi.aws.directconnect.GatewayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Gateway("example", GatewayArgs.builder()
 *             .name("tf-dxg-example")
 *             .amazonSideAsn("64512")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:directconnect:Gateway
 *     properties:
 *       name: tf-dxg-example
 *       amazonSideAsn: '64512'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Direct Connect Gateways using the gateway `id`. For example:
 * ```sh
 * $ pulumi import aws:directconnect/gateway:Gateway test abcd1234-dcba-5678-be23-cdef9876ab45
 * ```
 * @property amazonSideAsn The ASN to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
 * @property name The name of the connection.
 */
public data class GatewayArgs(
    public val amazonSideAsn: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.directconnect.GatewayArgs> {
    override fun toJava(): com.pulumi.aws.directconnect.GatewayArgs =
        com.pulumi.aws.directconnect.GatewayArgs.builder()
            .amazonSideAsn(amazonSideAsn?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var amazonSideAsn: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The ASN to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
     */
    @JvmName("mxjgchgtchbiqbqg")
    public suspend fun amazonSideAsn(`value`: Output<String>) {
        this.amazonSideAsn = value
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("dcvtuqfqwbpjhjng")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ASN to be configured on the Amazon side of the connection. The ASN must be in the private range of 64,512 to 65,534 or 4,200,000,000 to 4,294,967,294.
     */
    @JvmName("vnrcecklprwciofy")
    public suspend fun amazonSideAsn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.amazonSideAsn = mapped
    }

    /**
     * @param value The name of the connection.
     */
    @JvmName("ivbhgbxquqxnixno")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        amazonSideAsn = amazonSideAsn,
        name = name,
    )
}
